
#ifndef CONNECTION_H
#define CONNECTION_H

#include <QMessageBox>
#include <QSqlDatabase>
#include <QSqlError>
#include <QSqlQuery>
#include <QDir>



static bool createConnection(QString fileName)
{
    QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE");



    db.setDatabaseName(QDir::homePath() + QDir::separator() + fileName);


    if (!db.open()) {
        QMessageBox::critical(0, qApp->tr("Cannot open database"),
            qApp->tr("Unable to establish a database connection.\n"
                     "This software needs SQLite support. Please"
                     "Click Cancel to exit."), QMessageBox::Cancel);
        return false;
    }



    QSqlQuery query;

    query.exec("create table IF NOT EXISTS items (id integer primary key autoincrement, nome varchar(15), descrizione varchar(30), inizio DATETIME, prezzo double)");
    query.exec("create table IF NOT EXISTS lista (id integer primary key autoincrement, qta varchar(30), item INTEGER, FOREIGN KEY(item) REFERENCES items(id))");

    return true;
}



#endif // CONNECTION_H
