import Qt 4.7
import Qt.labs.gestures 1.0
import "/usr/share/qlshop/qmls"


Rectangle {
    id: pageListToShop
    width: parent.width; //height: 200
    color: "black"


    signal clickAdd();
    property bool mouseAreaEnabled: true


    Component {
        id: itemsDelegate

        Item {
            id: recipe


            property real detailsOpacity : 0

            width: listView.width
            height: 70


            Rectangle {
                id: background
                x: 2; y: 2; width: parent.width - x*2; height: parent.height - y*2
                color: "black"
                border.color: "#095f73"
                radius: 5
            }


            MouseArea {
                id: moueseArea
                anchors.fill: parent
                onClicked: recipe.state = 'ItemDetails';
                 enabled: mouseAreaEnabled
            }


            Row {
                id: topLayout
                x: 10; y: 10; height: 50; width: parent.width
                spacing: 10

                Column {
                    width: background.width - 20; height: 50
                    spacing: 5

                    Text {
                        id: nameLabel
                        text: model.nome
                        font.bold: true; font.pointSize: 20
                        color: "white"
                    }
                    Row {

                            spacing: 5
                        Text {
                            id: qtaLabel
                            text: "Q.ta"
                            font.pointSize: 20; font.bold: true
                            opacity: recipe.detailsOpacity
                            color: "black"
                        }



                        Rectangle {
                            id: lll

                            y: qtaLabel.y + 2
                             border.color: "orange"
                             border.width: 2

                             width: 200
                             height: 30
                             opacity: recipe.detailsOpacity

                             TextEdit {
                                 id: qta
                                 anchors.verticalCenter : lll.verticalCenter
                                height: 30
                                 text: "0"
                                 wrapMode: Text.WordWrap
                                 //width: parent.width
                                 color: "black"
                                 width: 400
                                 font.pointSize: 20

                            }
                        }

                    }
                }
            }
            Item {
                id: details
                x: 10; width: parent.width - 20
                anchors { top: topLayout.bottom; topMargin: 20; bottom: parent.bottom; bottomMargin: 10 }
                opacity: recipe.detailsOpacity



                Text {
                    id: priceLabel
                    text: "Price " + model.prezzo
                    font.pointSize: 20; font.bold: true
                    opacity: recipe.detailsOpacity

                }




            }


            TextButton {
                y: 10
                anchors { right: background.right; rightMargin: 10 }
                opacity: recipe.detailsOpacity
                text: "Close"

                onClicked: {recipe.state = ''; pageListToShop.clickAdd();}
            }

            TextButton {
                y: 100 + 30
                anchors { right: background.right; rightMargin: 10; topMargin: 80 }
                opacity: recipe.detailsOpacity
                text: "Add"

                onClicked: {modelList.addRow(model.id, qta.text); pageListToShop.clickAdd(); }
            }


            states: State {
                name: "ItemDetails"

                PropertyChanges { target: background; color: "white" }

                PropertyChanges { target: recipe; detailsOpacity: 1; x: 0 }
                PropertyChanges { target: recipe; height: 200 }


                PropertyChanges { target: listView; explicit: true; contentY: recipe.y }

                PropertyChanges { target: pageListToShop ; mouseAreaEnabled: false   }
                PropertyChanges { target: listView; interactive: false }
                PropertyChanges { target: nameLabel; color: "black" }
                PropertyChanges { target: priceLabel; color: "black" }

            }

            transitions: Transition {

                ParallelAnimation {
                    ColorAnimation { property: "color"; duration: 500 }
                    NumberAnimation { duration: 300; properties: "detailsOpacity,x,contentY,height,width" }
                }
            }
        }
    }

    // The actual list
    ListView {
        id: listView
        anchors.fill: parent

        height: parent.height - 100
        model: modelListItems
        delegate: itemsDelegate


    }
}

