/******************************************************************
* Shop List
* Author: Nicola De Filippo
* Version: 0.1
* License: GPL
*******************************************************************/

import Qt 4.7

import "/usr/share/qlshop/qmls"

Rectangle {
    id: page1
    width: parent.width; //height: 200
    color: "black"

    property bool mouseAreaEnabled: true

    Component {
        id: itemsDelegate

        Item {
            id: singleItem
            property real detailsOpacity : 0

            width: listViewItems.width
            height: 70

            // A simple rounded rectangle for the background
            Rectangle {
                id: background
                x: 2; y: 2; width: parent.width - x*2; height: parent.height - y*2
                color: "black"
                border.color: "#095f73"
                radius: 5
            }

            MouseArea {
                id: moueseArea
                anchors.fill: parent
                onClicked: singleItem.state = 'Item';
                enabled: mouseAreaEnabled
            }

            Row {
                id: topLayout
                x: 10; y: 10; height: 50; width: parent.width
                spacing: 10

                Column {
                    width: background.width - 20; height: 50
                    spacing: 5

                    Text {
                        id: name
                        text: model.nome
                        font.bold: true; font.pointSize: 20
                        color: "white"
                    }

                }
            }

            Item {
                id: details
                x: 10; width: parent.width - 20
                anchors { top: topLayout.bottom; topMargin: 10; bottom: parent.bottom; bottomMargin: 10 }
                opacity: singleItem.detailsOpacity

                Row {
                    spacing: 5
                Text {
                    id: priceLabel
                    text: "Price"
                    font.pointSize: 20; font.bold: true
                    opacity: singleItem.detailsOpacity
                    color: "white"
                }



                Rectangle {
                    id: lll

                     //anchors.bottom: parent.bottom
                     y: priceLabel.y
                     opacity: singleItem.detailsOpacity
                     width: 160
                     height: 40
                     border.color: "orange"
                     TextInput {
                         id:price
                         anchors.verticalCenter : lll.verticalCenter
                         //anchors.fill: lll
                         text: model.prezzo
                         font.pointSize: 20
                         width: parent.width
                            color: "white"
                            validator: DoubleValidator{bottom: 0.0;}

                 }
                }
            }



            }

            // A button to close the detailed view, i.e. set the state back to default ('').
            TextButton {
                y: 10
                anchors { right: background.right; rightMargin: 10 }
                opacity: singleItem.detailsOpacity
                text: "Close"

                onClicked: singleItem.state = '';
            }

            TextButton {
                y: 100 + 30
                anchors { right: background.right; rightMargin: 10; topMargin: 100 }
                opacity: singleItem.detailsOpacity
                text: "Save"

                onClicked: {modelListItems.setItemPrice(model.id, price.text);/*singleItem.state = '';*/}
            }


            states: State {
                name: "Item"

                PropertyChanges { target: background; color: "white" }

                PropertyChanges { target: singleItem; detailsOpacity: 1; x: 0 }
                PropertyChanges { target: singleItem; height: 200 }


                PropertyChanges { target: listViewItems; explicit: true; contentY: singleItem.y }

                PropertyChanges { target: page1 ; mouseAreaEnabled: false   }
                PropertyChanges { target: listViewItems; interactive: false }
                PropertyChanges { target: name; color: "black" }
                PropertyChanges { target: priceLabel; color: "black" }
                PropertyChanges { target: price; color: "black" }
            }

            transitions: Transition {

                ParallelAnimation {
                    ColorAnimation { property: "color"; duration: 500 }
                    NumberAnimation { duration: 300; properties: "detailsOpacity,x,contentY,height,width" }
                }
            }
        }
    }

    // The actual items list
    ListView {
        id: listViewItems
        anchors.fill: parent

        height: parent.height - 100
        model: modelListItems
        delegate: itemsDelegate


    }
}
