/******************************************************************
* Shop List
* Author: Nicola De Filippo
* Version: 0.1
* License: GPL
*******************************************************************/


import Qt 4.7

import Qt.labs.gestures 1.0

import "/usr/share/qlshop/qmls"

Rectangle {
    id: page
    width: parent.width;
    color: "black"

    property bool mouseAreaEnabled: true

    Component {
        id: articleDelegate

        Item {
            id: article

            property real detailsOpacity : 0

            width: listView.width
            height: 70


            Rectangle {
                id: background
                x: 2; y: 2; width: parent.width - x*2; height: parent.height - y*2
                color: "black"
                border.color: "#095f73"
                radius: 5
            }


            MouseArea {
            //GestureArea {

                id: moueseArea
                anchors.fill: parent
                onClicked: article.state = 'Details';
                enabled: mouseAreaEnabled
                //onTap: article.state = 'Details';
            }


            Row {
                id: topLayout
                x: 10; y: 10; height: 50; width: parent.width
                spacing: 10

                Column {
                    width: parent.width - 100; height: 100
                    spacing: 5

                    Text {
                        id: name
                        text: model.nome
                        font.bold: true; font.pointSize: 16
                        color: "white"
                    }
                    Text {
                        text: "Quantità: " + model.qta
                        font.pointSize: 16
                        opacity: 1
                        color: "white"
                    }
                }
            }

            Item {
                id: details
                x: 10; width: parent.width - 20
                height: 100
                anchors { top: topLayout.bottom; topMargin: 10;/* bottom: parent.bottom; bottomMargin: 10*/ }
                opacity: article.detailsOpacity

                Row {
                    spacing: 5
                    Text {
                        id: priceLabel
                        text: "Price"
                        font.pointSize: 16; font.bold: true
                        opacity: article.detailsOpacity + 1

                    }

                    Rectangle {
                         id: lll
                         border.color: "orange"
                         border.width: 2
                         opacity: article.detailsOpacity
                         y: priceLabel.y - 2

                         width: 60
                         height: 30
                         TextInput {
                             id: price
                             anchors.verticalCenter : lll.verticalCenter

                             text: {modelList.getPrice(model.id)}
                             width: parent.width
                             validator: DoubleValidator {bottom:0.0;}
                            font.pointSize: 16
                        }
                    }
                }
            }


            TextButton {
                y: 10
                anchors { right: background.right; rightMargin: 10 }
                opacity: article.detailsOpacity
                text: "Close"

                onClicked: article.state = '';
            }

            TextButton {
                y: 100 + 40
                anchors { right: background.right; rightMargin: 10; topMargin: 30 }
                opacity: article.detailsOpacity
                text: "Save"

                onClicked: {modelList.setPrice(model.id, price.text);article.state = '';}
            }


            states: State {
                name: "Details"

                PropertyChanges { target: background; color: "white" }

                PropertyChanges { target: article; detailsOpacity: 1; x: 0 }

                PropertyChanges { target: article; height: 200 }

                PropertyChanges { target: listView; explicit: true; contentY: article.y }


                PropertyChanges { target: listView; interactive: false;   }
                PropertyChanges { target: page ; mouseAreaEnabled: false   }
                PropertyChanges { target: name; color: "black" }
            }

            transitions: Transition {

                ParallelAnimation {
                    ColorAnimation { property: "color"; duration: 500 }
                    NumberAnimation { duration: 300; properties: "detailsOpacity,x,contentY,height,width" }
                }
            }
        }
    }

    // The Shop List
    ListView {
        id: listView
        anchors.fill: parent

        height: parent.height - 100
        model: modelList
        delegate: articleDelegate


    }
}
