/******************************************************************
* Class to use  QSqlRelationalTableModel from Qt Quick
* Author: Nicola De Filippo
* Version: 0.1
* License: GPL
*******************************************************************/


#ifndef QLSQLTABLEMODEL_H
#define QLSQLTABLEMODEL_H




#include <QSqlTableModel>
#include <QSqlRelationalTableModel>

class QLSqlTableModel : public QSqlRelationalTableModel
{
    Q_OBJECT
private:
    QHash<int, QByteArray> roles;
public:
    enum ItmesRoles {
             NomeRole = Qt::UserRole + 1,
             IdRole
         };

    QLSqlTableModel(QObject *parent = 0);
    ~QLSqlTableModel();
    QVariant data ( const QModelIndex & index, int role = Qt::DisplayRole ) const;
    void generateRoleNames();
    Q_INVOKABLE void clear();
    Q_INVOKABLE void addRow(int, QString);
    Q_INVOKABLE double getPrice(int id);
    Q_INVOKABLE void setPrice(int id, double price);
    Q_INVOKABLE void setItemPrice(int id, double price);
    Q_INVOKABLE void addItem(QString name, double price);
    Q_INVOKABLE int row();


};

#endif // QLSQLTABLEMODEL_H
