#include "qlsqltablemodel.h"
#include <QSqlRecord>
#include <QDebug>
#include <QSqlField>
#include <QSqlQuery>

QLSqlTableModel::QLSqlTableModel(QObject *parent): QSqlRelationalTableModel(parent)
{

   /* roles[NomeRole] = "nome";
    roles[IdRole] = "id";
    setRoleNames(roles);
*/
}

QVariant QLSqlTableModel::data ( const QModelIndex & index, int role ) const
{


    if (!index.isValid())
        return QVariant();


    QSqlRelationalTableModel m;
    m.setTable(this->tableName());
    m.select();

    if(index.row() >= m.rowCount())
        return QString("");

    for (int i = 0; i < columnCount(); i++) {
        QSqlRelation relation = this->relation(i);
        if (relation.isValid()) {
            m.setRelation(i, relation);
            m.select();
            QSqlRecord r = m.record(index.row());
            return r.value(QString(roles.value(role)));
        }
    }
    m.setTable(this->tableName());
    m.select();

    if(index.row() >= m.rowCount())
        return QString("");

    QSqlRecord r = m.record(index.row());

    qDebug() << "row count " << m.rowCount() << " row " << index.row() << " TABLE " << this->tableName() << " ROLE " << role << " role str "  << roles.value(role);

    return r.value(QString(roles.value(role)));


   /* QSqlRelationalTableModel m;
    m.setTable(this->tableName());
    m.setRelation(2, this->relation(2));
    m.select();
    QSqlRecord r = m.record(index.row());

    //qDebug() << "data TABLE " << this->tableName() << " ROLE " << QString(roles.value(role)) << "VALUE " << r.value(QString(roles.value(role))) << endl;
    return r.value(QString(roles.value(role)));
    //return r.value(headerData(index.column(), Qt::Horizontal).toString());*/


}

void QLSqlTableModel::generateRoleNames()
{
    roles.clear();
    for (int i = 0; i < this->columnCount(); i++) {

        roles[Qt::UserRole + i] = this->headerData(i, Qt::Horizontal).toByteArray();
        //qDebug() << "TABLE " << this->tableName() << " ruolo " << this->headerData(i, Qt::Horizontal).toString() << endl;
    }
    setRoleNames(roles);

}

void QLSqlTableModel::clear()
{

    this->removeRows(0, rowCount());


}

void QLSqlTableModel::addRow(int id, QString qta)
{

    QSqlRecord record;
    QSqlField f1("qta", QVariant::String);
    QSqlField f2("item", QVariant::Int);

    f1.setValue(qta);
    f2.setValue(id);
    record.append(f1);
    record.append(f2);
    insertRecord(-1, record);


}

double QLSqlTableModel::getPrice(int id)
{

    QSqlQuery query;
    bool ok;
    query = "select IFNULL(items.prezzo, 0), items.nome from items join lista on items.id = lista.item where lista.id = " + QString::number(id);
    while (query.next()) {
        double price = query.value(0).toDouble(&ok);

        return price;
    }
    return -1;
}


void QLSqlTableModel::setPrice(int id, double price)
{

    QSqlQuery query;

    query = "update items set prezzo = " + QString::number(price) + " where items.id = (select item from lista where lista.id=" + QString::number(id) +")";

    query.next();
}


void QLSqlTableModel::setItemPrice(int id, double price)
{

    QSqlQuery query;

    query = "update items set prezzo = " + QString::number(price) + " where items.id =" + QString::number(id);

    query.next();
}

 QLSqlTableModel::~QLSqlTableModel()
 {

 }

 void QLSqlTableModel::addItem(QString name, double price)
 {

     QSqlRecord record;
     QSqlField f1("nome", QVariant::String);
     QSqlField f2("prezzo", QVariant::Double);

     f1.setValue(name);
     f2.setValue(price);
     record.append(f1);
     record.append(f2);
     insertRecord(-1, record);


 }

 int QLSqlTableModel::row()
 {

    return rowCount();
 }
