include(../common)

TEMPLATE     = app
CONFIG      += qt
QT          += core gui sql network dbus maemo5
TARGET       = ../bin/qlm

CONFIG += mobility
MOBILITY = location

SOURCES     +=  main.cpp \
                GeoMath.cpp \
                IKeys.cpp \
                CCanvas.cpp \
                COSDLabel.cpp \
                CInfoScreen.cpp \
                IGps.cpp \
                CNMEA.cpp \
                CNMEA_Mtk.cpp \
                CDlgMenu.cpp \
                CDlgGps.cpp \
                CDlgGpsSetup.cpp \
                CDlgMap.cpp \
                CDlgWpt.cpp \
                CDlgWptDel.cpp \
                CDlgWptEdit.cpp \
                CDlgWptIcon.cpp \
                CDlgSystem.cpp \
                CDlgTransfer.cpp \
                IUnit.cpp \
                CUnitMetric.cpp \
                CUnitImperial.cpp \
                CUnitNautic.cpp \
                IDB.cpp \
                IMap.cpp \
                CMapDB.cpp \
                CMapWorld.cpp \
                CMapRaster.cpp \
                CTransferAgent.cpp \
                CWpt.cpp \
                CWptDB.cpp \
                CProtocol.cpp\
                WptIcons.cpp \
                CTrack.cpp \
                CTrackDB.cpp \
                CDlgTrack.cpp \
                CDlgTrackEdit.cpp \
                CMenu.cpp

HEADERS     +=  GeoMath.h \
                IKeys.h \
                CCanvas.h \
                COSDLabel.h \
                CInfoScreen.h \
                IGps.h \
                CNMEA.h \
                CNMEA_Mtk.h \
                CDlgMenu.h \
                CDlgGps.h \
                CDlgGpsSetup.h \
                CDlgMap.h \
                CDlgWpt.h \
                CDlgWptDel.h \
                CDlgWptEdit.h \
                CDlgWptIcon.h \
                CDlgSystem.h \
                CDlgTransfer.h \
                IUnit.h \
                CUnitMetric.h \
                CUnitImperial.h \
                CUnitNautic.h \
                IDB.h \
                IMap.h \
                CMapDB.h \
                CMapWorld.h \
                CMapRaster.h \
                CTransferAgent.h \
                CWpt.h \
                CWptDB.h \
                CBacklight.h \
                CProtocol.h \
                WptIcons.h \
                CTrack.h \
                CTrackDB.h \
                CDlgTrack.h \
                CDlgTrackEdit.h \
                CMenu.h

win32 {
    RC_FILE     +=  qlandkarte.rc
    CONFIG      +=  static
}

unix:QMAKE_QWS {
    SOURCES     +=  CDlgEdit.cpp
    HEADERS 	+=  CDlgEdit.h
}

QMAKE_NO_BACKLIGHT_VIA_TS {
    DEFINES += NO_BACKLIGHT_VIA_TS
}

QMAKE_DISPLAY_LARGE {
    FORMS   +=  ICanvas_large.ui \
                IInfoScreen_large.ui \
                IDlgMenu_large.ui \
                IDlgGps_large.ui \
                IDlgGpsSetup_large.ui \
                IDlgMap_large.ui \
                IDlgSystem_large.ui \
                IDlgWpt_large.ui \
                IDlgWptDel_large.ui \
                IDlgWptIcon_large.ui \
                IDlgWptEdit_large.ui \
                IDlgTransfer.ui \
                IDlgEdit.ui \
                IDlgTrack_large.ui \
                IDlgTrackEdit_large.ui

    DEFINES += DISPLAY_LARGE
}

QMAKE_DISPLAY_SMALL {
    FORMS   +=  ICanvas_small.ui \
                IInfoScreen_small.ui \
                IDlgMenu_small.ui \
                IDlgGps_small.ui \
                IDlgGpsSetup_small.ui \
                IDlgMap_small.ui \
                IDlgSystem_small.ui \
                IDlgWpt_small.ui \
                IDlgWptDel_small.ui \
                IDlgWptEdit_small.ui \
                IDlgWptIcon_small.ui \
                IDlgTransfer.ui \
                IDlgEdit.ui \
                IDlgTrack_small.ui \
                IDlgTrackEdit_small.ui

    DEFINES += DISPLAY_SMALL
}

QMAKE_DISPLAY_NOKIA {
    FORMS   +=  ICanvas_Nokia.ui \
                IInfoScreen_Nokia.ui \
	        IDlgMenu_small.ui \
	        IDlgGps_Nokia.ui \
	        IDlgGpsSetup_small.ui \
	        IDlgMap_small.ui \
	        IDlgSystem_small.ui \
	        IDlgWpt_small.ui \
	        IDlgWptDel_small.ui \
	        IDlgWptEdit_small.ui \
	        IDlgWptIcon_small.ui \
	        IDlgTransfer.ui \
	       IDlgEdit.ui \
	        IDlgTrack_small.ui \
	        IDlgTrackEdit_small.ui
    HEADERS += CNokia.h
    SOURCES += CNokia.cpp

	        DEFINES += DISPLAY_NOKIA
	        DEFINES += DISPLAY_SMALL
	        DEFINES += NOKIA
                DEFINES += Q_WS_MAEMO_5
                #LIBS += -llocation
                #INCLUDEPATH += /usr/include/glib-2.0
                #INCLUDEPATH += /usr/lib/glib-2.0/include
		INCLUDEPATH += /usr/include/gdal
	}


QMAKE_QWS {
    DEFINES += QWS
}

QMAKE_LIBDIR = ../bin/3rdparty

unix:SOURCES     += CBacklight.cpp
unix:LIBS        += -L../bin -l3rdparty -lgdal1.5.0 -lproj -lm
unix:INCLUDEPATH  += .tmp ../3rdparty

win32:HEADERS     += CGpsd.h
win32:SOURCES     += CGpsd.cpp CBacklight_wince.cpp
win32:LIBS        += -l3rdparty -lgdalce_i -lproj_i -lgpsapi
win32:INCLUDEPATH  = .tmp ../3rdparty ../../proj/src ../../gdal-1.4.2/port ../../gdal-1.4.2/gcore ../../gdal-1.4.2/ogr ../../wcelibcex-1.0/src

RESOURCES   += resources.qrc
DESTDIR      = ../bin
MOC_DIR      = .tmp
UI_DIR       = .tmp
OBJECTS_DIR  = .tmp
RCC_DIR      = .tmp

unix {
     #VARIABLES
     isEmpty(PREFIX) {
         PREFIX = /usr/local
   }
   BINDIR = $$PREFIX/bin
   DATADIR =$$PREFIX/share

   DEFINES += DATADIR=\"$$DATADIR\" PKGDATADIR=\"$$PKGDATADIR\"

   #MAKE INSTALL

   INSTALLS += target desktop icon

     target.path =$$BINDIR

     desktop.path = $$DATADIR/applications/hildon
     desktop.files += qlandkartem.desktop

     icon.path = $$DATADIR/pixmaps
     icon.files += icons/qlandkartem.png
}

