/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/

#include "CCanvas.h"

#include <QApplication>
#include <QtGui>
#include <gdal_priv.h>

int main(int argc, char ** argv)
{
    GDALAllRegister();
    // 10 MB should be enought for every one
    GDALSetCacheMax(1024*1024*10);

    QApplication app(argc, argv);
    QApplication::setApplicationName("QLandkarteM");
    QApplication::setOrganizationName("QLandkarteM");

#ifdef DISPLAY_LARGE
    QFont font = QApplication::font();
    font.setPointSize(font.pointSize() + 3);
    QApplication::setFont(font);
#endif

    CCanvas w;
    w.setFocus();
    w.show();
#ifndef WINCE
#ifdef QWS
    app.setKeypadNavigationEnabled(true);
#endif
#endif
    int res = app.exec();

    GDALDestroyDriverManager();

    return res;
}
