/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#ifndef CDLGMENU_H
#define CDLGMENU_H

#include <QDialog>

#ifdef DISPLAY_SMALL
#include<ui_IDlgMenu_small.h>
#else                            //DISPLAY_SMALL
#include<ui_IDlgMenu_large.h>
#endif                           //DISPLAY_SMALL

#include "IKeys.h"

class CDlgGps;
class CDlgMap;
class CDlgWpt;
class CDlgTrack;

class CDlgMenu : public QDialog, public IKeys, private Ui::IDlgMenu
{
    Q_OBJECT;
    public:
        CDlgMenu(QWidget * parent);
        virtual ~CDlgMenu();

        static CDlgMenu * self(){return m_self;};

    protected:
        void paintEvent(QPaintEvent * e);
        bool eventFilter(QObject *obj, QEvent *event){return IKeys::eventFilter(obj, event);}

    private slots:
        void slotRestart();
        void slotReboot();
        void slotKey1();
        void slotKey2();
        void slotKey3();
        void slotKey4();

        void slotWptDelete();
        void slotWptDeleteAll();
        void slotWptEdit();

        void slotTrkDelete();
        void slotTrkDeleteAll();
        void slotTrkEdit();

    private:
        void setPage(int idx);

        enum page_e{eAbout, eGps, eMap, eWpt, eTrack, eMaxPage};
        CDlgGps * dlgGps;
        CDlgMap * dlgMap;
        CDlgWpt * dlgWpt;
        CDlgTrack * dlgTrack;

        static CDlgMenu * m_self;
};
#endif                           //CDLGMENU_H
