/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/

#include "COSDLabel.h"
#include <QtGui>

COSDLabel::COSDLabel(QWidget * parent)
: QWidget(parent)
,flags(Qt::AlignCenter)
{

}


COSDLabel::~COSDLabel()
{

}


void COSDLabel::paintEvent(QPaintEvent * e)
{
    QPainter p;
    p.begin(this);
    draw(p);
    p.end();

    QWidget::paintEvent(e);
}


void COSDLabel::draw(QPainter& p)
{
    QFont           f = parentWidget()->font();
    f.setWeight(QFont::Bold);
    QFontMetrics    fm(f);

    QRect r = frameGeometry();
    r.moveTo(0,0);

    p.setPen(Qt::white);
    p.setFont(f);

    p.drawText(r.adjusted(-1,-1,-1,-1), flags, str);
    p.drawText(r.adjusted( 0,-1, 0,-1), flags, str);
    p.drawText(r.adjusted(+1,-1,+1,-1), flags, str);

    p.drawText(r.adjusted(-1, 0,-1, 0), flags, str);
    p.drawText(r.adjusted(+1, 0,+1, 0), flags, str);

    p.drawText(r.adjusted(-1,+1,-1,+1), flags, str);
    p.drawText(r.adjusted( 0,+1, 0,+1), flags, str);
    p.drawText(r.adjusted(+1,+1,+1,+1), flags, str);

    p.setPen(Qt::black);
    p.drawText(r, flags, str);

}
