/****************************************************************************
**
** Copyright (C) 2000-2008 TROLLTECH ASA. All rights reserved.
**
** This file is part of the Opensource Edition of the Qtopia Toolkit.
**
** This software is licensed under the terms of the GNU General Public
** License (GPL) version 2.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QSERIALPORT_H
#define QSERIALPORT_H

#ifdef WINCE
#include <windows.h>

#define snprintf _snprintf
#define strdup _strdup
#define strcasecmp _stricmp
#define strncasecmp _strnicmp
#define vsnprintf _vsnprintf

#if defined(__GNUC__)
#define       __try           try
#define       __except(x)     catch(...)
#else
#define       inline  _inline
#endif

#ifndef _T
#define _T(x) L ## x
#endif

#endif

#include <qserialiodevice.h>
#include <QtGui>
#include <QTimer>

class QSerialPortPrivate;
class Win_QextSerialThread;

class QSerialPort : public QSerialIODevice
{
    Q_OBJECT
    friend class Win_QextSerialThread;
public:
    explicit QSerialPort( const QString& device, int rate = 38400, bool trackStatus = false );
    ~QSerialPort();

    int fd() const;
    QTimer *waitReady; 
        
    // Override QIODevice methods.
    bool open( OpenMode mode );
    void close();
    bool flush();
    bool waitForReadyRead(int msecs);
    qint64 bytesAvailable() const;
    // Get or set the CTS/RTS flow control mode.
    bool flowControl() const;
    void setFlowControl( bool value );

    bool keepOpen() const;
    void setKeepOpen( bool value );

    // Override QSerialIODevice methods.
    int rate() const;
    bool dtr() const;
    void setDtr( bool value );
    bool dsr() const;
    bool carrier() const;
    bool rts() const;
    void setRts( bool value );
    bool cts() const;
    void discard();
    bool isValid() const;
    QProcess *run( const QStringList& arguments, bool addPPPdOptions );

    // Create and open a serial device from a "device:rate" name.
    static QSerialPort *create( const QString& name, int defaultRate=115200,
                                bool flowControl=false );

protected:
#ifdef WINCE
		Win_QextSerialThread * overlapThread; ///< @todo maybe move to QextSerialBase (and implement in POSIX).
		void monitorCommEvent();
		void terminateCommWait();
#endif

    qint64 readData( char *data, qint64 maxlen );
    qint64 writeData( const char *data, qint64 len );

private slots:
    void statusTimeout();
    void pppdStateChanged( QProcess::ProcessState state );
    void pppdDestroyed();
    void slotWaitReady();
    void slotStartMonitor();

private:
    QSerialPortPrivate *d;
};

#ifdef WINCE
/*!
 * This thread monitors communication events.
 */
class Win_QextSerialThread: public QThread
{
	QSerialPort * qesp;
	bool terminate;

	public:
		/*!
		 * Constructor.
		 * 
		 * \param qesp valid serial port object.
		 */
		Win_QextSerialThread(QSerialPort * qesp);
		
		/*!
		 * Stop the thread.
		 */
		void stop();
	
	protected:
		//overriden
		virtual void run();
	
};
#endif


#endif // QSERIALPORT_H
