/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#ifndef CWPTDB_H
#define CWPTDB_H

#include "IDB.h"

#include <QSqlDatabase>
#include <QSet>

class CWpt;

class CWptDB : public IDB
{
    Q_OBJECT;
    public:
        virtual ~CWptDB();

        static CWptDB& self(){return *m_self;}

        void draw(QPainter& p, const QRectF& viewport);

        bool add(CWpt& wpt, QString& errmsg);

        bool del(const QString& key, QString& errmsg);

        bool delByIcon(const QString& icon, QString& errmsg);

        bool list(QStringList& keys, QStringList& names, QStringList& icons, QString& errmsg);

        bool get(const QString& key, CWpt& wpt, QString& errmsg);

        bool getUsedIcons(QSet<QString>& result, QString& errmsg);

    public slots:
        void addWptToPos();

    private:
        friend class CCanvas;

        CWptDB(QObject * parent);

        static CWptDB * m_self;

        /// remove old database and recreate an empty database
        void initDB();
        void migrateDB(QString &version);

        bool delWptImg(int wptidx, QString& errmsg);

        /// the database file path
        QString dbName;
        /// use this database object exclusively
        QSqlDatabase db;

        QString pathImages;

};
#endif                           //CWPTDB_H
