/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#include "CDlgTrack.h"
#include "CTrackDB.h"

#include <QtGui>
#include <QtMaemo5>

CDlgTrack::CDlgTrack(QWidget * parent)
: QWidget(parent)
{
    setupUi(this);
    connect(&CTrackDB::self(), SIGNAL(sigChanged()), this, SLOT(slotDBChanged()));

    slotDBChanged();
}

CDlgTrack::~CDlgTrack()
{

}

void CDlgTrack::slotDBChanged()
{
    QStringList keys, names, dist;
    QString errmsg;

    CTrackDB::self().list(keys, names, dist, errmsg);

    listTracks->clear();

    for(int i = 0; i < keys.count(); ++i){
        QListWidgetItem * item = new QListWidgetItem(listTracks);
        item->setText(names[i]+"( "+dist[i]+" )");
        item->setData(Qt::UserRole, keys[i]);
    }
    new QMaemo5KineticScroller(listTracks);
    listTracks->sortItems();
}

QString CDlgTrack::getCurrentKey()
{
    QString key;

    QListWidgetItem * item = listTracks->currentItem();
    if(item){
        key = item->data(Qt::UserRole).toString();
    }

    return key;
}
