#ifndef CATEGORY_H
#define CATEGORY_H

#include <QWidget>
#include <QList>

class QString;
class QStringList;
class QSpinBox;
class QLabel;

class Category : public QWidget
{
    Q_OBJECT
public:
    explicit Category(QWidget *parent, QString categoryName, bool totalShow, QStringList itemsNames);
    ~Category();

private:
    QLabel *category;
    QString name;
    int total;
    bool showTotal;
    QList<QSpinBox *> *list;
    QList<QLabel *> *items;

    void readSettings();
    void saveSettings();

private slots:
    void setTitle();

signals:

public slots:
    QString getName();
    void setName(QString);
    int getTotal();
    void reset();


};

#endif // CATEGORY_H
