#include "maemoinstructionswindow.h"
#include "texteditautoresizer.h"
#include <QVBoxLayout>

MaemoInstructionsWindow::MaemoInstructionsWindow(QWidget *parent, QString instructions) :
    QMainWindow(parent)
{
    textEdit = new QTextEdit;
    textEdit->setReadOnly(true);

    scrollArea = new QScrollArea;

    textEdit->setText(instructions);

    QVBoxLayout *layout = new QVBoxLayout;
    layout->addWidget(textEdit);

    new TextEditAutoResizer(textEdit);

    QWidget *widget = new QWidget;
    widget->setLayout(layout);
    scrollArea->setWidget(textEdit);

    setCentralWidget(scrollArea);
    scrollArea->setWidgetResizable(true);

    setAttribute(Qt::WA_Maemo5StackedWindow);
    setWindowFlags(this->windowFlags() | Qt::Window);
}
