#include "category.h"
#include <QString>
#include <QStringList>
#include <QSpinBox>
#include <QLabel>
#include <QVBoxLayout>
#include <QPixmap>
#include <QSettings>
#include <QHBoxLayout>



Category::Category(QWidget *parent,
                   QString categoryName,
                   bool totalShow,
                   QStringList itemsNames) :    QWidget(parent)
{
    QVBoxLayout *mainLayout = new QVBoxLayout;
    category = new QLabel;
    name = categoryName;
    showTotal=totalShow;
    mainLayout->addWidget(category);
    QPixmap line(750, 2);
    line.fill(Qt::white);
    QLabel *lineL = new QLabel;
    lineL->setPixmap(line);
    lineL->setFixedWidth(700);
    mainLayout->addWidget(lineL);

    list=new QList<QSpinBox *>;
    items = new QList<QLabel *>;

    for (int i=0; i<itemsNames.size(); i++)
    {
        QHBoxLayout *layout = new QHBoxLayout;
        QLabel *itemName = new QLabel(itemsNames.at(i));
        items->append(itemName);
        layout->addWidget(itemName);
        layout->addStretch();
        QSpinBox *itemBox = new QSpinBox;
        connect(itemBox, SIGNAL(valueChanged(int)), SLOT(setTitle()));
        list->append(itemBox);
        layout->addWidget(itemBox);
        mainLayout->addLayout(layout);
    }

    readSettings();
    setTitle();
    setLayout(mainLayout);

}

Category::~Category()
{
    saveSettings();
}

QString Category::getName()
{
    return category->text();
}

void Category::setName(QString newName)
{
    category->setText(newName);
}

int Category::getTotal()
{
    return total;
}

void Category::reset()
{
    for (int i=0; i<list->size(); i++)
    {
        list->at(i)->setValue(0);
    }
}

void Category::readSettings()
{
    int itemsNumber = list->size();
    QSettings settings("inventory", "items");


    for (int i=0; i<itemsNumber; i++)
    {
        list->at(i)->setValue(settings.value(items->at(i)->text(), 0).toInt());
    }

}

void Category::saveSettings()
{
    int itemsNumber = list->size();
    QSettings settings("inventory", "items");

    for (int i=0; i<itemsNumber; i++)
    {
        settings.setValue(items->at(i)->text(), list->at(i)->value());

    }

}

void Category::setTitle()
{
    total=0;
    int itemsNumber = list->size();
    for (int i=0; i<itemsNumber; i++)
    {
        total+=list->at(i)->value();
    }

    if (showTotal) category->setText(name + " (" + QString::number(total) + ")");
    else category->setText(name);
}
