/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "aboutqimsysobject.h"
#include "aboutqimsys.h"

#include <QApplication>

#include "qimsysapplicationmanager.h"
#include "translator.h"

class AboutQimsysObject::Private : private QObject
{
    Q_OBJECT
public:
    Private(AboutQimsysObject *parent);
    ~Private();

private slots:
    void enabledChanged(bool enabled);
    void exec(int action);

private:
    AboutQimsysObject *q;
    QimsysApplicationManager manager;
public:
    AboutQimsys *window;
};

AboutQimsysObject::Private::Private(AboutQimsysObject *parent)
    : QObject(parent)
    , q(parent)
    , window(0)
{
    q->setCategoryType(AlwaysOne);
    TR(q, "categoryName", this, QT_TR_NOOP("User Interface/About QIMSYS"));

    q->setIcon(qApp->windowIcon());
    TR(q, "name", this, QT_TR_NOOP("About QIMSYS"));
    TR(q, "author", this, QT_TR_NOOP("Tasuku Suzuki"));
    TR(q, "translator", this, QT_TR_NOOP("None"));
    connect(q, SIGNAL(enabledChanged(bool)), this, SLOT(enabledChanged(bool)));
    enabledChanged(q->isEnabled());

    manager.init();
    connect(&manager, SIGNAL(triggered(int)), this, SLOT(exec(int)));

}

AboutQimsysObject::Private::~Private()
{
    delete window;
}

void AboutQimsysObject::Private::enabledChanged(bool enabled)
{
    if (enabled && !window) {
        window = new AboutQimsys;
    } else if (!enabled && window) {
        delete window;
        window = 0;
    }
}

void AboutQimsysObject::Private::exec(int action)
{
    switch (action) {
    case QimsysApplicationManager::ShowAboutQimsys:

        if (window->isVisible()) {
            window->activateWindow();
        } else {
            window->show();
        }
        break;
    default:
        break;
    }
}


AboutQimsysObject::AboutQimsysObject(QObject *parent)
    : QimsysAbstractPluginObject(parent)
{
    d = new Private(this);
}

AboutQimsysObject::~AboutQimsysObject()
{
    delete d;
}
#include "aboutqimsysobject.moc"
