/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef SIMPLELISTWIDGET_H
#define SIMPLELISTWIDGET_H

#include <QFrame>

class SimpleListWidget : public QFrame
{
    Q_OBJECT
public:
    explicit SimpleListWidget(QWidget *parent = 0);
    ~SimpleListWidget();

    void keyEvent(QKeyEvent *e);
public slots:
    void setItems(const QStringList &list);
    void setCurrentIndex(int index);

signals:
    void currentIndexChanged(int index);

protected:
    virtual Qt::KeyboardModifiers modifiers() const;

private:
    class Private;
    Private *d;
};

#endif//SIMPLELISTWIDGET_H
