/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "inputlanguagemanager.h"

#include <qimsysdebug.h>
#include <qimsysapplicationmanager.h>
#include <qimsyspluginmanager.h>
#include <qimsysconverter.h>

#include <QSettings>

class InputLanguageManager::Private : private QObject
{
    Q_OBJECT
public:
    Private(InputLanguageManager *parent);
    ~Private();

private slots:
    void init();
    void inputLanguageChanged(const QString &inputLanguage);

private:
    InputLanguageManager *q;
    QimsysApplicationManager manager;
};

InputLanguageManager::Private::Private(InputLanguageManager *parent)
    : QObject(parent)
    , q(parent)
{
    qimsysDebugIn() << parent;
    q->setCategoryType(Hidden);

    manager.init();
    connect(&manager, SIGNAL(inputLanguageChanged(QString)), this, SLOT(inputLanguageChanged(QString)));
    metaObject()->invokeMethod(this, "init", Qt::QueuedConnection);
    qimsysDebugOut();
}

InputLanguageManager::Private::~Private()
{
}

void InputLanguageManager::Private::init()
{
    qimsysDebugIn();
    QSettings settings;
    settings.beginGroup(q->metaObject()->className());
    QString inputLanguage = settings.value(QLatin1String("InputLanguage"), QLatin1String("ja_JP")).toString();
    manager.setInputLanguage(inputLanguage);
    qimsysDebugOut();
}

void InputLanguageManager::Private::inputLanguageChanged(const QString &inputLanguage)
{
    qimsysDebugIn() << inputLanguage;
    QList<QimsysConverter *> converters = QimsysPluginManager::objects<QimsysConverter>();
    foreach(QimsysConverter *converter, converters) {
        converter->setActive(converter->identifier() == inputLanguage);
    }

    QSettings settings;
    settings.beginGroup(q->metaObject()->className());
    settings.setValue("InputLanguage", inputLanguage);
    qimsysDebugOut();
}

InputLanguageManager::InputLanguageManager(QObject *parent)
    : QimsysAbstractPluginObject(parent)
{
    qimsysDebugIn() << parent;
    d = new Private(this);
    qimsysDebugOut();
}

InputLanguageManager::~InputLanguageManager()
{
    qimsysDebugIn();
    delete d;
    qimsysDebugOut();
}

#include "inputlanguagemanager.moc"
