/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "qt4immoduleplugin.h"
#include "qt4immodule.h"
#include "qimsysdebug.h"

QimsysIMModulePlugin::QimsysIMModulePlugin(QObject *parent)
    : QInputContextPlugin(parent)
{
    qimsysDebugIn() << parent;
    qimsysDebugOut();
}

QimsysIMModulePlugin::~QimsysIMModulePlugin()
{
    qimsysDebugIn();
    qimsysDebugOut();
}

QInputContext *QimsysIMModulePlugin::create(const QString &key)
{
    if (key != keys().first()) return 0;
    qimsysDebugIn() << key;
    Qt4IMModule *ret = new Qt4IMModule(this);
    if (!ret->available()) {
        delete ret;
        ret = 0;
    }
    qimsysDebugOut() << ret;
    return ret;
}

QString QimsysIMModulePlugin::description(const QString &key)
{
    if (key != keys().first()) return tr("");
    return tr("An input method module for qimsys");
}

QString QimsysIMModulePlugin::displayName(const QString &key)
{
    if (key != keys().first()) return tr("");
    return tr("qimsys");
}

QStringList QimsysIMModulePlugin::keys() const
{
    return QStringList() << QLatin1String("qimsys");
}

QStringList QimsysIMModulePlugin::languages(const QString &key)
{
    QStringList ret;
    if (key != keys().first()) return ret;
    ret << QLatin1String("ja");
    return ret;
}

Q_EXPORT_PLUGIN2(qimsysIMModulePlugin, QimsysIMModulePlugin)
