/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef QIMSYSPREEDITITEMLIST_H
#define QIMSYSPREEDITITEMLIST_H

#include <glib-object.h>
#include "qimsysglobal.h"

#ifdef __cplusplus
extern "C" {
#endif

G_BEGIN_DECLS

#define QIMSYSPREEDITITEMLIST_TYPE            (qimsys_preedit_item_list_get_type())
#define QIMSYSPREEDITITEMLIST(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), QIMSYSPREEDITITEMLIST_TYPE, QimsysPreeditItemList))
#define QIMSYSPREEDITITEMLIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), QIMSYSPREEDITITEMLIST_TYPE, QimsysPreeditItemListClass))
#define IS_QIMSYSPREEDITITEMLIST(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), QIMSYSPREEDITITEMLIST_TYPE))
#define IS_QIMSYSPREEDITITEMLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), QIMSYSPREEDITITEMLIST_TYPE))
#define QIMSYSPREEDITITEMLIST_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), QIMSYSPREEDITITEMLIST, QimsysPreeditItemListClass))

typedef struct {
    const char *text;
    int cursor;
    int selection;
    int underline_style;
} QimsysPreeditItem;

#define QIMSYS_STRUCT_PREEDITITEM (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INVALID))
#define QIMSYS_STRUCT_PREEDITITEMLIST (dbus_g_type_get_collection ("GPtrArray", QIMSYS_STRUCT_PREEDITITEM))

typedef struct _QimsysPreeditItemList       QimsysPreeditItemList;
typedef struct _QimsysPreeditItemListClass  QimsysPreeditItemListClass;

struct _QimsysPreeditItemList
{
    GObject instance_parent;

    GArray *items;
};

struct _QimsysPreeditItemListClass
{
    GObjectClass class_parent;

    void (* qimsys_preedit_item_list) (QimsysPreeditItemList *qpil);
};

QIMSYS_EXPORT GType qimsys_preedit_item_list_get_type();
QIMSYS_EXPORT QimsysPreeditItemList *qimsys_preedit_item_list_new();

G_END_DECLS

#ifdef __cplusplus
}
#endif

#endif // QIMSYSPREEDITITEMLIST_H
