/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef QIMSYSPREEDIT_H
#define QIMSYSPREEDIT_H

#include "qimsysabstractipcobject.h"
#include "qimsyspreedititemlist.h"

#ifdef __cplusplus
extern "C" {
#endif

G_BEGIN_DECLS

#define QIMSYSPREEDIT_TYPE            (qimsys_preedit_get_type())
#define QIMSYSPREEDIT(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), QIMSYSPREEDIT_TYPE, QimsysPreedit))
#define QIMSYSPREEDIT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), QIMSYSPREEDIT_TYPE, QimsysPreeditClass))
#define IS_QIMSYSPREEDIT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), QIMSYSPREEDIT_TYPE))
#define IS_QIMSYSPREEDIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), QIMSYSPREEDIT_TYPE))
#define QIMSYSPREEDIT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), QIMSYSPREEDIT, QimsysPreeditClass))

typedef struct _QimsysPreedit       QimsysPreedit;
typedef struct _QimsysPreeditClass  QimsysPreeditClass;

struct _QimsysPreedit
{
    QimsysAbstractIpcObject object;
};

struct _QimsysPreeditClass
{
    QimsysAbstractIpcObjectClass parent_class;

    void (* qimsys_preedit) (QimsysPreedit *qam);
};

QIMSYS_EXPORT GType qimsys_preedit_get_type();
QIMSYS_EXPORT QimsysPreedit *qimsys_preedit_new();

QIMSYS_EXPORT gboolean qimsys_preedit_get_items(QimsysPreedit *qam, QimsysPreeditItemList **value);
QIMSYS_EXPORT gboolean qimsys_preedit_set_items(QimsysPreedit *qam, QimsysPreeditItemList *value);
// signal: "items-changed"

QIMSYS_EXPORT gboolean qimsys_preedit_get_rect(QimsysPreedit *qam, int *x, int *y, int *w, int *h);
QIMSYS_EXPORT gboolean qimsys_preedit_set_rect(QimsysPreedit *qam, int x, int y, int w, int h);
// signal: "rect-changed"

#ifdef QIMSYSPREEDIT_FONT_SUPPORT
QIMSYS_EXPORT gboolean qimsys_preedit_get_font(QimsysPreedit *qam, char **value);
QIMSYS_EXPORT gboolean qimsys_preedit_set_font(QimsysPreedit *qam, char *value);
// signal: "font-changed"
#endif

QIMSYS_EXPORT gboolean qimsys_preedit_get_cursor_position(QimsysPreedit *qam, int *cursor_position);
QIMSYS_EXPORT gboolean qimsys_preedit_set_cursor_position(QimsysPreedit *qam, int cursor_position);
// signal: "cursor-position-changed"

QIMSYS_EXPORT gboolean qimsys_preedit_get_surrounding_text(QimsysPreedit *qam, char **surrounding_text);
QIMSYS_EXPORT gboolean qimsys_preedit_set_surrounding_text(QimsysPreedit *qam, const char *surrounding_text);
// signal: "surrounding-text-changed"

QIMSYS_EXPORT gboolean qimsys_preedit_get_current_selection(QimsysPreedit *qam, char **current_selection);
QIMSYS_EXPORT gboolean qimsys_preedit_set_current_selection(QimsysPreedit *qam, const char *current_selection);
// signal: "current-selection-changed"

QIMSYS_EXPORT gboolean qimsys_preedit_get_maximum_text_length(QimsysPreedit *qam, int *maximum_text_length);
QIMSYS_EXPORT gboolean qimsys_preedit_set_maximum_text_length(QimsysPreedit *qam, int maximum_text_length);
// signal: "maximum-text-length-changed"

QIMSYS_EXPORT gboolean qimsys_preedit_commit(QimsysPreedit *qam, guint target);
// signal: "committed"
G_END_DECLS

#ifdef __cplusplus
}
#endif

#endif // QIMSYSPREEDIT_H
