#!/usr/bin/env python
# qice.py
#       Copyright 2008 kinta <kinta@communia.org>
#       
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.
# deps= libshout shout2send
import sys
from PyQt4 import QtCore
from PyQt4 import QtGui
import os
import subprocess
import pygst
pygst.require('0.10')
import gst
import gst.interfaces
import ConfigParser
#
import gobject
#

stream=["host", "port", "mountpoint", "user", "pw"]
sndarch="pulsesrc"#"dsppcmsrc"#"alsasrc"
sndarchsink="pulsesink"#"dsppcmsink"#"alsasink"
term="osso-xterm"#"xterm"
home_directory = os.environ["HOME"]
config_directory = home_directory + '/.qice'
if os.path.isdir(config_directory):
	pass
else:
	os.popen("mkdir "+config_directory)
config_file = config_directory + '/server.cfg'
config = ConfigParser.ConfigParser()
config.read(config_file)
if config.has_section("server"):
        print("configuracio trobada")
else:
        print("no te lopcio per tant escribim")
        config.add_section("server")
        for index,item in enumerate(stream):
                config.set("server",item,item)
        targetwrite=file(config_file,'w')
        config.write(targetwrite)
        targetwrite.close()


class MainWindow(QtGui.QMainWindow):
   def __init__(self, * args):
       apply(QtGui.QMainWindow.__init__, (self, ) + args)
       gobject.threads_init()
       
       
       
       central = QtGui.QWidget(self)
       self.mainlayout=QtGui.QVBoxLayout(central)
       self.tabWidget=QtGui.QTabWidget(central)
       self.tabAudio=Audio()
       self.tabVideo=Video()
       
       self.tabWidget.addTab(self.tabAudio,"Audio")
       self.tabWidget.addTab(self.tabVideo,"Video")

       self.editServer = self.menuBar().addAction(self.tr("Edit c&onnection"))
       self.quitAction = self.menuBar().addAction(self.tr("E&xit"))
       #self.mixer = self.fileMenu.addAction(self.tr("&Mixer"))
       
       self.connect(self.quitAction, QtCore.SIGNAL("triggered()"), self.quito)
       #self.connect(self.editServer, QtCore.SIGNAL("triggered()"), self.setserver)
       self.connect(self.editServer, QtCore.SIGNAL("triggered()"), self.createWizard)
       #self.connect(self.mixer, QtCore.SIGNAL("triggered()"), self.aumixer)
       



       
       central.setLayout(self.mainlayout)
       self.setCentralWidget(central)
       
       self.mainlayout.addWidget(self.tabWidget)
       self.loadConf()

   def createWizard(self):
       self.wizard=QtGui.QWizard()
       self.wizard.addPage(self.createSettingsPage())
       self.wizard.setOptions(QtGui.QWizard.NoBackButtonOnLastPage|QtGui.QWizard.NoCancelButton)
       self.connect(self.wizard, QtCore.SIGNAL("accepted()"),self.saveSettings)
       self.wizard.show()

   def createSettingsPage(self):
       page = QtGui.QWizardPage()
       page.setTitle("Server settings")
       page.setSubTitle("Please fill both fields.")

       hostLabel = QtGui.QLabel("Host:")
       self.hostLineEdit = QtGui.QLineEdit(self.server)

       portLabel = QtGui.QLabel("Port:")
       self.portLineEdit = QtGui.QLineEdit(self.port)

       pwLabel = QtGui.QLabel("password:")
       self.pwLineEdit = QtGui.QLineEdit(self.pw)
       self.pwLineEdit.setEchoMode(self.pwLineEdit.Password)
       mpLabel = QtGui.QLabel("mount point:")
       self.mpLineEdit = QtGui.QLineEdit(self.mount)

       layout = QtGui.QGridLayout()
       layout.addWidget(hostLabel, 0, 0)
       layout.addWidget(self.hostLineEdit, 0, 1)
       layout.addWidget(portLabel, 1, 0)
       layout.addWidget(self.portLineEdit, 1, 1)
       layout.addWidget(pwLabel, 2, 0)
       layout.addWidget(self.pwLineEdit, 2, 1)
       layout.addWidget(mpLabel, 3, 0)
       layout.addWidget(self.mpLineEdit, 3, 1)

       page.setLayout(layout)


       return page


   def saveSettings(self):
       print "saving settings"
       config.set("server","host",self.hostLineEdit.text())
       config.set("server","port",self.portLineEdit.text())
       config.set("server","mountpoint",self.mpLineEdit.text())
       config.set("server","pw",self.pwLineEdit.text())
       targetwrite=file(config_file,'w')
       config.write(targetwrite)
       targetwrite.close()
       self.loadConf()

   def loadConf(self):
       self.server=str(config.get("server","host"))
       self.port=str(config.get("server","port"))
       self.mount=str(config.get("server","mountpoint"))
       self.pw=str(config.get("server","pw"))
       self.user=str(config.get("server","user"))
       self.tabAudio.loadConf()
       self.tabVideo.loadConf()
       #self.info("settings changed")





   def alert(self, msg):
	QtGui.QMessageBox.critical(self, 'CRITICAL', msg, QtGui.QMessageBox.Ok)

   def info(self, msg):
	QtGui.QMessageBox.information(self,'info', msg)
   def pregunta(self, msg):
        pregunta=QtGui.QMessageBox.question(self, 'ATENCIO', msg, QtGui.QMessageBox.Ok | QtGui.QMessageBox.Cancel)
        #resposta=pregunta.exec()
        if pregunta == 1024:
                return "OK"
        else :
                return "Cancel"
   def quito(self,**kwargs):
        self.close()



class Audio(QtGui.QWidget):
   def __init__(self, parent=None):
	QtGui.QWidget.__init__(self, parent)
	self.vlayout = QtGui.QGridLayout(self)
	
	self.stream = QtGui.QPushButton("Stream", self)
	#self.dump = QtGui.QPushButton("dump", self)
	self.muteStreamMic=QtGui.QPushButton("mute", self)
	self.monitor = QtGui.QPushButton("Monitor", self)
	self.record = QtGui.QPushButton("Record", self)
	self.tofiledest = QtGui.QLabel("to:",self)
	self.filedest = QtGui.QLineEdit("qice.oga",self)
	self.filedest.setMaximumWidth(120)
	#self.label = QtGui.QTextEdit("",self)
	self.label = QtGui.QLabel("",self)
	
	#self.label.setReadOnly(True)
	#self.label.setGeometry(10, 10, 61, 41)
	self.stream.setCheckable(1)
	self.muteStreamMic.setCheckable(1)
	#self.dump.setCheckable(1)
	self.monitor.setCheckable(1)
	self.record.setCheckable(1)

	#self.dump.setEnabled(False)
	self.muteStreamMic.setEnabled(False)
	
	
	
	self.vlayout.addWidget(self.stream,0,0,1,1)
	#self.vlayout.addWidget(self.dump,1,0,1,1)
	self.vlayout.addWidget(self.muteStreamMic,1,0,1,1)
	#self.vlayout.addSpacing(20)
	self.vlayout.addWidget(self.monitor,0,1,1,1)
	self.vlayout.addWidget(self.record,0,2,1,2)
	self.vlayout.addWidget(self.label,2,0,1,4)
	
	self.vlayout.addWidget(self.tofiledest,1,2,1,1)
	self.vlayout.addWidget(self.filedest,1,3,1,1)
	
	self.connect(self.stream, QtCore.SIGNAL("clicked()"), self.streamcon)
	#self.connect(self.dump, QtCore.SIGNAL("clicked()"), self.dumpstream)
	self.connect(self.muteStreamMic, QtCore.SIGNAL("clicked()"), self.mute)
	self.connect(self.monitor, QtCore.SIGNAL("clicked()"), self.monstr)
	self.connect(self.record, QtCore.SIGNAL("clicked()"), self.recordstr)      
	
   def eventos(self, bus, msg):
	#DEBUG = print(str(msg)+" "+str(msg.type))
	t = msg.type	
	if t == gst.MESSAGE_UNKNOWN:
		e, d = msg.parse_error()
		self.label.setText("CONNECT ERROR: "+str(e))
	if t == gst.MESSAGE_ERROR:
		e, d = msg.parse_error()
		self.label.setText("ERROR: "+str(e))
	return True
   def connectEventos(self, bus, msg):
	#DEBUG = print(str(msg)+" "+str(msg.type))
	t = msg.type	
	if t == gst.MESSAGE_UNKNOWN:
		e, d = msg.parse_error()
		self.label.setText("CONNECT ERROR: "+e)
	if t == gst.MESSAGE_ERROR:
		e, d = msg.parse_error()
		self.label.setText("ERROR: "+str(e))
		self.stream.setChecked(False)
		self.streamcon()
	return True
   def connectEventRec(self, bus, msg):
	#DEBUG = print(str(msg)+" "+str(msg.type))
	t = msg.type	
	if t == gst.MESSAGE_UNKNOWN:
		e, d = msg.parse_error()
		self.label.setText("CONNECT ERROR: "+e)
	if t == gst.MESSAGE_ERROR:
		e, d = msg.parse_error()
		self.label.setText("ERROR: "+str(e))
		self.record.setChecked(False)
		self.recordstr()
	return True
   def connectEventMon(self, bus, msg):
	#DEBUG = print(str(msg)+" "+str(msg.type))
	t = msg.type	
	if t == gst.MESSAGE_UNKNOWN:
		e, d = msg.parse_error()
		self.label.setText("CONNECT ERROR: "+e)
	if t == gst.MESSAGE_ERROR:
		e, d = msg.parse_error()
		self.label.setText("ERROR: "+str(e))
		self.monitor.setChecked(False)
		self.monstr()
	return True
   #def dumpstream(self):
       #if self.dump.isChecked():
        	#filename = QtGui.QFileDialog.getSaveFileName(self, 'Where?',home_directory)
        	#self.filename = str(filename)
		#self.label.setText("dumping")
		#mplayer=os.popen2( term+" -e \"mplayer http://"+self.server+":"+self.port+"/"+self.mount+" -dumpstream -dumpfile "+self.filename+" && sleep 2\"")[1].readline()
		
       #else:
	        #pidofmp=os.popen2("pidof mplayer")[1].readline()
		#if pidofmp!="":
			#os.popen2("kill -15 `pidof mplayer`")      
   def streamcon(self):
       if self.stream.isChecked():
	        try:
			self.label.setText("connecting")

			self.audio_pipeline = gst.parse_launch(sndarch+" ! volume name=\"volume0\" ! audioconvert ! vorbisenc name=\"enc\" quality=0.10 ! queue ! oggmux name=mux ! queue ! shout2send  ip="+self.server+" port="+self.port+" password="+self.pw+" mount=/"+self.mount)
			self.volumesrc=self.audio_pipeline.get_by_name("volume0")
			#help(self.audio_pipeline)
			
			self.audio_pipeline.get_bus().add_watch(self.connectEventos)
			self.audio_pipeline.set_state(gst.STATE_PLAYING)
			self.label.setText("connected")
			#self.record.setEnabled(False)
			self.monitor.setEnabled(False)
       			#self.dump.setEnabled(True)
       			self.muteStreamMic.setEnabled(True)
		except gobject.GError, e:
			self.label.setText("No es posible crear la tuberia, " + str(e))
			self.stream.setChecked(0)
			return -1
       else:
		self.label.setText("disconnecting")
		try:
			#self.dump.setChecked(False)
			#self.dumpstream()
			self.audio_pipeline.set_state(gst.STATE_NULL)
			self.label.setText("disconnected")
			self.record.setEnabled(True)
			self.monitor.setEnabled(True)
       			#self.dump.setEnabled(False)
       			self.muteStreamMic.setEnabled(False)
		except gobject.GError, e:
			self.label.setText("No es posible canviar a estat nul la tuberia, " + str(e))
			return -1
   def mute(self):
	self.volumesrc.set_property("mute",self.muteStreamMic.isChecked())
   def monstr(self):
       if self.monitor.isChecked():
	        try:
			self.label.setText("monitoring")
			#This is the parse launch (no parameters allowed)
			#self.mon_pipeline = gst.parse_launch(sndarch+" !"+sndarchsink)
			#self.mon_pipeline.get_bus().add_watch(self.eventos)
			#self.mon_pipeline.set_state(gst.STATE_PLAYING)
			#self.record.setEnabled(False)
			#self.stream.setEnabled(False)
			#self.audiofx= gst.element_factory_make("audioecho","fx")
			#self.audiofx.set_property("delay",500000000);self.audiofx.set_property("intensity",0.6);self.audiofx.set_property("feedback",0.4);
			#self.mon_pipeline.add(self.audiofx)
			
			self.mon_pipeline = gst.Pipeline('pipeline')
			src = gst.element_factory_make(sndarch)
			sink = gst.element_factory_make(sndarchsink)
			self.mon_pipeline.add(src,sink)
			gst.element_link_many(src,sink)

			self.record.setEnabled(False)
			self.stream.setEnabled(False)
			#This is a test to insert fx on the pipeline.
			#self.audiofx= gst.element_factory_make("audioecho")
			#self.audiofx.set_property("delay",500000000);self.audiofx.set_property("intensity",0.6);self.audiofx.set_property("feedback",0.4);
			#self.mon_pipeline.add(self.audiofx)
			#self.audiofx2= gst.element_factory_make("audiowsincband","fx2")
			#self.mon_pipeline.add(self.audiofx2)
			#gst.element_unlink_many(src,sink)
			#gst.element_link_many(src,self.audiofx,sink)
			
			self.mon_pipeline.get_bus().add_watch(self.connectEventMon)
			self.mon_pipeline.set_state(gst.STATE_PLAYING)
			
		except gobject.GError, e:
			self.label.setText("No es posible crear la tuberia, " + str(e))
			self.monitor.setChecked(0)
			return -1
       else:
		self.label.setText("disabling monitor")
		try:
			self.mon_pipeline.set_state(gst.STATE_NULL)
			self.label.setText("unmonitoring")
			self.record.setEnabled(True)
			self.stream.setEnabled(True)
		except gobject.GError, e:
			self.label.setText("No es posible canviar a estat nul la tuberia, " + str(e))
			return -1      
   def recordstr(self):
       if self.record.isChecked():
        	#filename = QtGui.QFileDialog.getSaveFileName(self, 'Where?',home_directory)
        	#filename = str(filename)
        	filename = "/home/user/MyDocs/"+str(self.filedest.text())
	        try:
			self.label.setText("recording")
			self.rec_pipeline = gst.parse_launch(sndarch+" ! audioconvert ! vorbisenc name=\"enc\" quality=0.10 ! queue ! oggmux name=mux ! queue ! filesink location="+filename)
			self.rec_pipeline.get_bus().add_watch(self.connectEventRec)
			self.rec_pipeline.set_state(gst.STATE_PLAYING)
			self.stream.setEnabled(True)
			self.monitor.setEnabled(False)
		except gobject.GError, e:
			self.label.setText("No es posible crear la tuberia, " + str(e))
			self.record.setChecked(0)
			return -1
       else:
		self.label.setText("stop recording")
		try:
			self.rec_pipeline.set_state(gst.STATE_NULL)
			self.label.setText("stoped")
			self.stream.setEnabled(True)
			self.monitor.setEnabled(True)
		except gobject.GError, e:
			self.label.setText("No es posible canviar a estat nul la tuberia, " + str(e))
			return -1	
   def loadConf(self):
       self.server=str(config.get("server","host"))
       self.port=str(config.get("server","port"))
       self.mount=str(config.get("server","mountpoint"))
       self.pw=str(config.get("server","pw"))
       self.user=str(config.get("server","user"))

class Video(QtGui.QWidget):
   def __init__(self, parent=None):
       QtGui.QWidget.__init__(self, parent)
       self.vlayout = QtGui.QGridLayout(self)
       
       self.stream = QtGui.QPushButton("Stream", self)
       #self.dump = QtGui.QPushButton("dump", self)
       self.muteStreamMic=QtGui.QPushButton("mute", self)
       self.monitor = QtGui.QPushButton("Monitor", self)
       self.record = QtGui.QPushButton("Record", self)
       self.tofiledest = QtGui.QLabel("to:",self)
       self.filedest = QtGui.QLineEdit("qice.ogv",self)
       self.filedest.setMaximumWidth(120)
       self.label = QtGui.QLabel("",self)
       
       self.viewVideo=QtGui.QWidget(self)
       
       videoSizePolicy=QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.MinimumExpanding)
       self.viewVideo.setSizePolicy(videoSizePolicy)
       self.comboBox = QtGui.QComboBox(self);
       self.comboBox.insertItems(0,["width=160,height=90","width=160,height=120","width=320,height=240"])#,"width=640,height=480"])
       self.stream.setCheckable(1)
       self.muteStreamMic.setCheckable(1)
       #self.dump.setCheckable(1)
       self.monitor.setCheckable(1)
       self.record.setCheckable(1)

       #self.dump.setEnabled(False)
       self.muteStreamMic.setEnabled(False)
       
       
      
       self.vlayout.addWidget(self.stream,1,0,1,1)
       #self.vlayout.addWidget(self.dump,2,0,1,1)
       self.vlayout.addWidget(self.muteStreamMic,2,0,1,1)
       #self.vlayout.addSpacing(20)
       self.vlayout.addWidget(self.monitor,1,1,1,1)
       self.vlayout.addWidget(self.record,1,2,1,2)
       self.vlayout.addWidget(self.tofiledest,2,2,1,1)
       self.vlayout.addWidget(self.filedest,2,3,1,1)
       self.vlayout.addWidget(self.viewVideo,0,0,1,3)
       self.vlayout.addWidget(self.comboBox, 0, 3, 1, 1)
       self.vlayout.addWidget(self.label,4,0,1,2)
       

       self.connect(self.stream, QtCore.SIGNAL("clicked()"), self.streamcon)
       #self.connect(self.dump, QtCore.SIGNAL("clicked()"), self.dumpstream)
       self.connect(self.muteStreamMic, QtCore.SIGNAL("clicked()"), self.mute)
       self.connect(self.monitor, QtCore.SIGNAL("clicked()"), self.monstr)
       self.connect(self.record, QtCore.SIGNAL("clicked()"), self.recordstr)


	
   def eventos(self, bus, msg):
	#DEBUG = print(str(msg)+" "+str(msg.type))
	t = msg.type	
	if t == gst.MESSAGE_UNKNOWN:
		e, d = msg.parse_error()
		self.label.setText("CONNECT ERROR: "+str(e))
	if t == gst.MESSAGE_ERROR:
		e, d = msg.parse_error()
		self.label.setText("ERROR: "+str(e))
	return True
   def connectEventos(self, bus, msg):
	#DEBUG = print(str(msg)+" "+str(msg.type))
	t = msg.type	
	if t == gst.MESSAGE_UNKNOWN:
		e, d = msg.parse_error()
		self.label.setText("CONNECT ERROR: "+e)
	if t == gst.MESSAGE_ERROR:
		e, d = msg.parse_error()
		self.label.setText("ERROR: "+str(e))
		self.stream.setChecked(False)
		self.streamcon()
	return True
   def streamcon(self):
       if self.stream.isChecked():
	        try:
			self.label.setText("connecting")
			if self.record.isChecked():
				preview=""
			else:
				preview="tee name=t1 ! queue ! xvimagesink  sync=false t1. ! queue !"
			self.audio_pipeline = gst.parse_launch("v4l2camsrc ! queue ! ffmpegcolorspace ! "+preview+" videoscale ! video/x-raw-yuv,"+str(self.comboBox.currentText())+" !  theoraenc quality=16 ! queue ! oggmux name=mux "+sndarch+" ! volume name=\"volume0\"  ! audio/x-raw-int,rate=8000,channels=1,depth=8 ! queue ! audioconvert ! vorbisenc ! queue ! mux. mux. ! queue ! shout2send ip="+self.server+" port="+self.port+" password="+self.pw+" mount=/"+self.mount)
			self.volumesrc=self.audio_pipeline.get_by_name("volume0")
			
			
			
			bus=self.audio_pipeline.get_bus()
			bus.add_watch(self.connectEventos)
			bus.enable_sync_message_emission()
			bus.connect("sync-message::element", self.on_sync_message)
			
			self.audio_pipeline.set_state(gst.STATE_PLAYING)
			self.label.setText("connected")
			self.record.setEnabled(False)
			self.monitor.setEnabled(False)
       			#self.dump.setEnabled(True)
       			self.muteStreamMic.setEnabled(True)
		except gobject.GError, e:
			self.label.setText("No es posible crear la tuberia, " + str(e))
			self.stream.setChecked(0)
			return -1
       else:
		self.label.setText("disconnecting")
		try:
			#self.dump.setChecked(False)
			#self.dumpstream()
			self.audio_pipeline.set_state(gst.STATE_NULL)
			self.label.setText("disconnected")
			self.record.setEnabled(True)
			self.monitor.setEnabled(True)
       			#self.dump.setEnabled(False)
       			self.muteStreamMic.setEnabled(False)
		except gobject.GError, e:
			self.label.setText("No es posible canviar a estat nul la tuberia, " + str(e))
			return -1
   def mute(self):
	self.volumesrc.set_property("mute",self.muteStreamMic.isChecked())
   def monstr(self):
       if self.monitor.isChecked():
	        try:
			self.label.setText("monitoring")
			#This is the parse launch
			self.mon_pipeline = gst.parse_launch("v4l2camsrc ! queue ! ffmpegcolorspace ! xvimagesink")
			bus=self.mon_pipeline.get_bus()
			bus.add_watch(self.connectEventMon)
			bus.enable_sync_message_emission()
			bus.connect("sync-message::element", self.on_sync_message)
			self.record.setEnabled(False)
			self.stream.setEnabled(False)
			self.mon_pipeline.set_state(gst.STATE_PLAYING)
			
		except gobject.GError, e:
			self.label.setText("No es posible crear la tuberia, " + str(e))
			self.monitor.setChecked(0)
			return -1
       else:
		self.label.setText("disabling monitor")
		try:
			self.mon_pipeline.set_state(gst.STATE_NULL)
			self.label.setText("unmonitoring")
			self.record.setEnabled(True)
			self.stream.setEnabled(True)
		except gobject.GError, e:
			self.label.setText("No es posible canviar a estat nul la tuberia, " + str(e))
			return -1
   def recordstr(self):
       if self.record.isChecked():
        	#filename = QtGui.QFileDialog.getSaveFileName(self, 'Where?',home_directory)
        	#filename = str(filename)
        	filename = "/home/user/MyDocs/"+str(self.filedest.text())
	        try:
			
			self.label.setText("recording")
			if self.stream.isChecked():
				preview=""
			else:
				preview="tee name=t1 ! queue ! xvimagesink  sync=false t1. ! queue !"
			self.rec_pipeline = gst.parse_launch("v4l2camsrc ! queue ! ffmpegcolorspace ! "+preview+" videoscale ! video/x-raw-yuv,"+str(self.comboBox.currentText())+" !  theoraenc quality=16 ! queue ! oggmux name=mux "+sndarch+" ! audio/x-raw-int,rate=8000,channels=1,depth=8 ! queue ! audioconvert ! vorbisenc ! queue ! mux. mux. ! queue ! filesink location="+filename)
			
			bus=self.rec_pipeline.get_bus()
			bus.add_watch(self.connectEventRec)
			bus.enable_sync_message_emission()
			bus.connect("sync-message::element", self.on_sync_message)
			
			self.rec_pipeline.set_state(gst.STATE_PLAYING)
			self.stream.setEnabled(False)
			self.monitor.setEnabled(False)
			print "recording"
		except gobject.GError, e:
			self.label.setText("No es posible crear la tuberia, " + str(e))
			self.record.setChecked(0)
			return -1
       else:
		self.label.setText("stop recording")
		try:
			self.rec_pipeline.set_state(gst.STATE_NULL)
			self.label.setText("stoped")
			self.stream.setEnabled(True)
			self.monitor.setEnabled(True)
		except gobject.GError, e:
			self.label.setText("No es posible canviar a estat nul la tuberia, " + str(e))
			return -1	
   def eventos(self, bus, msg):
	#DEBUG = print(str(msg)+" "+str(msg.type))
	t = msg.type	
	if t == gst.MESSAGE_UNKNOWN:
		e, d = msg.parse_error()
		self.label.setText("CONNECT ERROR: "+str(e))
	if t == gst.MESSAGE_ERROR:
		e, d = msg.parse_error()
		self.label.setText("ERROR: "+str(e))
	return True
   def connectEventos(self, bus, msg):
	#DEBUG = print(str(msg)+" "+str(msg.type))
	t = msg.type	
	if t == gst.MESSAGE_UNKNOWN:
		e, d = msg.parse_error()
		self.label.setText("CONNECT ERROR: "+e)
	if t == gst.MESSAGE_ERROR:
		e, d = msg.parse_error()
		self.label.setText("ERROR: "+str(e))
		self.stream.setChecked(False)
		self.streamcon()
	return True
   def connectEventRec(self, bus, msg):
	#DEBUG = print(str(msg)+" "+str(msg.type))
	t = msg.type	
	if t == gst.MESSAGE_UNKNOWN:
		e, d = msg.parse_error()
		self.label.setText("CONNECT ERROR: "+e)
	if t == gst.MESSAGE_ERROR:
		e, d = msg.parse_error()
		self.label.setText("ERROR: "+str(e))
		self.record.setChecked(False)
		self.recordstr()
	return True
   def connectEventMon(self, bus, msg):
	#DEBUG = print(str(msg)+" "+str(msg.type))
	t = msg.type	
	if t == gst.MESSAGE_UNKNOWN:
		e, d = msg.parse_error()
		self.label.setText("CONNECT ERROR: "+e)
	if t == gst.MESSAGE_ERROR:
		e, d = msg.parse_error()
		self.label.setText("ERROR: "+str(e))
		self.monitor.setChecked(False)
		self.monstr()
	return True

   def on_sync_message(self, bus, message):
	if message.structure is None:
		return
	message_name = message.structure.get_name()

	if message_name == "prepare-xwindow-id":
		# Assign the viewport
		print message_name
		print self.viewVideo.winId()
		imagesink = message.src
		imagesink.set_property("force-aspect-ratio", True)
		imagesink.set_xwindow_id(self.viewVideo.winId())#self.movie_window.window.xid)
	
   def loadConf(self):
       self.server=str(config.get("server","host"))
       self.port=str(config.get("server","port"))
       self.mount=str(config.get("server","mountpoint"))
       self.pw=str(config.get("server","pw"))
       self.user=str(config.get("server","user"))


def main(args):
   app=QtGui.QApplication(args)
   win=MainWindow()
   win.show()
   win.setWindowTitle("Qice")
   app.connect(app, QtCore.SIGNAL("lastWindowClosed()")
               , app
               , QtCore.SLOT("quit()")
               )
   app.exec_()

if __name__=="__main__":
       main(sys.argv)
