/*
qgvdial is a cross platform Google Voice Dialer
Copyright (C) 2010  Yuvraaj Kelkar
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
Contact: yuvraaj@gmail.com
*/
import Qt 4.7
Rectangle {
id: container
signal longPress
signal sigHide
signal sigClose
property int tabsHeight : 50
property int tabIndex : 0
property VisualItemModel tabsModel
anchors.fill: parent
Rectangle {
id: tabViewContainer
width: parent.width
color: "black"
anchors.top: tabBar.bottom
anchors.bottom: parent.bottom
Repeater {
model: tabsModel
}
}
Component.onCompleted:
{
tabClicked(tabIndex);
}
function tabClicked(index)
{
tabs.children[tabIndex].color = "transparent";
tabsModel.children[tabIndex].state = '';
tabIndex = index;
tabs.children[tabIndex].color = "#30ffffff";
tabsModel.children[tabIndex].state = "Visible";
}
Component {
id: tabBarItem
Rectangle {
height: tabs.height
width: tabs.width / tabsModel.count
color: "transparent"
Image {
source: tabsModel.children[index].icon
anchors {
fill: parent
centerIn: parent
}
fillMode: Image.PreserveAspectFit
}
MouseArea {
anchors.fill: parent
onClicked: tabClicked(index);
}
}
}
Rectangle {
id: tabBar
height: tabsHeight
width: parent.width
anchors {
left: parent.left
right: parent.right
top: parent.top
}
gradient: Gradient {
GradientStop {position: 0.0; color: "#666666"}
GradientStop {position: 1.0; color: "#000000"}
}
Rectangle {
id: rectX
color: "black"
anchors.right: tabBar.right
width: tabBar.height
height: tabBar.height
Image {
id: imgClose
source: "close.png"
anchors.centerIn: parent
width: parent.width / 2
height: parent.height / 2
fillMode: Image.Stretch
}
MouseArea {
id: xMouseArea
anchors.fill: parent
onClicked: container.sigHide();
onPressAndHold: container.sigClose();
}
states: State {
name: "pressed"
when: xMouseArea.pressed
PropertyChanges { target: rectX; color: "orange" }
}
}
Row {
anchors {
left: tabBar.left
right: rectX.left
top: parent.top
bottom: parent.bottom
}
id: tabs
Repeater {
model: tabsModel.count
delegate: tabBarItem
}
}
}
}
