import Qt 4.7
Rectangle {
property int tabsHeight : 50
property int tabIndex : 0
property VisualItemModel tabsModel
anchors.fill: parent
Rectangle {
id: tabViewContainer
width: parent.width
anchors.top: tabBar.bottom
anchors.bottom: parent.bottom
Repeater {
model: tabsModel
}
}
Component.onCompleted:
{
for(var i = 0; i < tabsModel.children.length; i++)
{
tabsModel.children[i].visible = false;
}
tabClicked(tabIndex);
}
function tabClicked(index)
{
tabs.children[tabIndex].color = "transparent";
tabsModel.children[tabIndex].visible = false;
tabIndex = index;
tabs.children[tabIndex].color = "#30ffffff";
tabsModel.children[tabIndex].visible = true;
}
Component {
id: tabBarItem
Rectangle {
height: tabs.height
width: tabs.width / tabsModel.count
color: "transparent"
Image {
source: tabsModel.children[index].icon
anchors {
fill: parent
centerIn: parent
}
fillMode: Image.PreserveAspectFit
}
MouseArea {
anchors.fill: parent
onClicked: {
tabClicked(index);
}
}
}
}
Rectangle {
height: tabsHeight
width: parent.width
anchors {
left: parent.left
right: parent.right
top: parent.top
}
id: tabBar
gradient: Gradient {
GradientStop {position: 0.0; color: "#666666"}
GradientStop {position: 1.0; color: "#000000"}
}
Row {
anchors.fill: parent
id: tabs
Repeater {
model: tabsModel.count
delegate: tabBarItem
}
}
}
}
