import Qt 4.7
import "helper.js" as Code
Rectangle {
id: main
width: g_MainWidth
height: g_MainHeight
color: "black"
signal sigCall(string number)
signal sigText(string number)
signal sigSelChanged(int index)
signal sigVoicemail(string link)
signal sigVmailPlayback(int playState)
signal sigInboxSelect(string selection)
signal sigUserChanged(string username)
signal sigPassChanged(string password)
signal sigLogin
signal sigLogout
signal sigRefresh
signal sigRefreshAll
signal sigHide
signal sigQuit
signal sigLinkActivated(string strLink)
signal sigProxyChanges(bool bEnable,
bool bUseSystemProxy,
string host, int port,
bool bRequiresAuth,
string user, string pass)
signal sigMosquittoChanges(bool bEnable, string host, int port, string topic)
signal sigPinSettingChanges(bool bEnable, string pin)
signal sigSearchContacts(string query)
signal sigMsgBoxDone (bool ok)
onSigCall: console.debug("QML: Call " + number)
onSigText: console.debug("QML: Text " + number)
onSigLogin: console.debug("QML: Login")
onSigLogout: console.debug("QML: Logout")
onSigRefresh: console.debug("QML: Refresh requested")
onSigRefreshAll: console.debug("QML: Refresh All requested")
onSigHide: console.debug("QML: Dismiss requested");
onSigQuit: console.debug("QML: Quit requested");
property bool landscape: (main.width > main.height)
property int nMargins: 1
property bool bShowSettings: g_bShowSettings
onBShowSettingsChanged: {
if (bShowSettings) {
console.debug("Settings on");
main.state = "Settings";
} else {
console.debug("Settings off");
main.state = '';
}
}
onSigMosquittoChanges: console.debug("QML: Mosquitto setings changed");
onSigLinkActivated: console.debug("QML: Link activated: " + strLink);
onSigMsgBoxDone: {
console.debug ("QML: User requested close on message box. Ok = " + ok)
}
Item {
id: mainColumn
property int centralHeight: mainColumn.height - barStatus.height
property int centralWidth: mainColumn.width
anchors {
top: parent.top
left: parent.left
right: parent.right
bottom: barStatus.top
}
//////////////////////////////////////////////////////////////////////////////
//                          Co-existent Items Begin                           
//////////////////////////////////////////////////////////////////////////////
VisualItemModel {
id: tabsModel
Tab {
icon: "dialpad.svg"
MainView {
id: dialPad
anchors.fill: parent
onSigCall: main.sigCall (number)
onSigText: main.sigText (number)
onSigSelChanged: main.sigSelChanged(index)
onSigMsgBoxDone: main.sigMsgBoxDone(ok)
}
}
Tab {
icon: "people.svg"
ContactsList {
id: contactsList
anchors.fill: parent
onSigCall: main.sigCall (number)
onSigText: main.sigText (number)
onSigMsgBoxDone: main.sigMsgBoxDone(ok)
onSigSearchContacts: main.sigSearchContacts(query)
}
}
Tab {
icon: "history.svg"
InboxList {
id: inboxList
anchors.fill: parent
onSigCall: main.sigCall (number)
onSigText: main.sigText (number)
onSigInboxSelect: main.sigInboxSelect(selection)
onSigVoicemail: main.sigVoicemail(link)
onSigMsgBoxDone: main.sigMsgBoxDone(ok)
onSigVmailPlayback: main.sigVmailPlayback(playState)
}
}
Tab {
icon: "settings.svg"
color: "black"
Settings {
id: settingsView
anchors.fill: parent
onSigUserChanged: main.sigUserChanged(username)
onSigPassChanged: main.sigPassChanged(password)
onSigLogin: main.sigLogin()
onSigLogout: main.sigLogout()
onSigRefresh: main.sigRefresh()
onSigRefreshAll: main.sigRefreshAll()
onSigHide: main.sigHide()
onSigQuit: main.sigQuit()
onSigProxyChanges: main.sigProxyChanges(bEnable, bUseSystemProxy,
host, port, bRequiresAuth,
user, pass)
onSigLinkActivated: main.sigLinkActivated(strLink)
onSigMosquittoChanges: main.sigMosquittoChanges(bEnable, host, port, topic)
onSigPinSettingChanges: main.sigPinSettingChanges(bEnable, pin)
onSigMsgBoxDone: main.sigMsgBoxDone(ok)
}
}
}
TabbedUI {
id: tabbedUI
tabsHeight: (main.height + main.width) / 20
tabIndex: 3
tabsModel: tabsModel
anchors {
top: parent.top
topMargin: nMargins
bottomMargin: nMargins
}
width: mainColumn.centralWidth
height: mainColumn.centralHeight
}
MsgBox {
id: msgBox
opacity: ((main.state == '' && g_bShowMsg == true) ? 1 : 0)
msgText: g_strMsgText
width: mainColumn.centralWidth - 20
height: (mainColumn.centralWidth + mainColumn.centralHeight) / 6
anchors.centerIn: mainColumn
onSigMsgBoxOk: main.sigMsgBoxDone(true)
onSigMsgBoxCancel: main.sigMsgBoxDone(false)
}
//////////////////////////////////////////////////////////////////////////////
//                           Co-existent Items End                            
//////////////////////////////////////////////////////////////////////////////
}
Rectangle {
id: barStatus
width: parent.width
height: (parent.height + parent.width) / 30
anchors.bottom: parent.bottom
color: "black"
Text {
text: g_strStatus
font.pixelSize: (parent.height * 2 / 3)
anchors.verticalCenter: parent.verticalCenter
anchors.horizontalCenter: parent.horizontalCenter
color: "white"
}
}
}
