#include <QtGui/qpainter.h>
#include <QSettings>
#include <QAction>
#include <QDebug>
#include <QtDBus/QtDBus>

#include "qflipclock-widget.h"
#include "widgetsettings.h"
#include "config.h"

QFlipClock_Widget::QFlipClock_Widget()
        : QFlipClock()
        , _clickAction(Action_Flipclock)
{
    setAttribute(Qt::WA_TranslucentBackground);

    QSettings settings(ORGANIZATION_NAME, APPLICATION_NAME);
    setTransition(TransitionsEnum(
            settings.value("Main/Transition", Transition_Flip).toInt()));
    setNewClickAction(ActionEnum(
            settings.value("Main/ClickAction", Action_Flipclock).toInt()));

    QAction *settingsAction = new QAction(tr("&Settings"), this);
    connect(settingsAction, SIGNAL(triggered()), SLOT(showSettingsDialog()));

#if !defined(Q_OS_SYMBIAN) && !defined(Q_WS_MAEMO_5)
    addAction(settingsAction);
    setContextMenuPolicy(Qt::ActionsContextMenu);
#endif

    int width = settings.value("Main/Width", DEFAULT_WIDTH).toInt();
    resize(width, getHeight(width));
    toggleShowBackground(settings.value("Main/ShowBackground", true).toBool());
    toggleZeroSign(settings.value("Main/PrependZeroSign", true).toBool());
}

QSize QFlipClock_Widget::sizeHint() const
{
    return QFlipClock::sizeHint();
}

void QFlipClock_Widget::showSettingsDialog()
{
    WidgetSettings dlg;
    if (dlg.exec() == QDialog::Accepted)
    {
        setNewWidth(dlg.getWidth());
        setNewShowBackground(dlg.getBackground());
        setNewZeroSign(dlg.getZeroSign());
        setNewTheme(dlg.getTheme());
        setNewTransition(dlg.getTransition());
        setNewClickAction(dlg.getClickAction());
        dlg.close();
    }
}

/*
 * Hook for homescreenChanged signal.
 * Stop the timer when homescreen is hidden,
 * and resume on homescreen is shown.
 * It also handles screen lock/unlock events.
 */
void QFlipClock_Widget::homescreenChangedHook(
                        bool isCurrentHomescreen)
{
    if (isCurrentHomescreen)
    {
        updateTime(true);
        startTimer();
    }
    else
    {
        stopTimer();
    }
}

void QFlipClock_Widget::setNewWidth(int width)
{
    QSettings settings(ORGANIZATION_NAME, APPLICATION_NAME);
    int _width = (width > MIN_WIDTH && width < MAX_WIDTH)
                    ? width : DEFAULT_WIDTH;
    settings.setValue("Main/Width", _width);
    resize(_width, getHeight(_width));
}

void QFlipClock_Widget::setNewTransition(TransitionsEnum transition)
{
    QSettings settings(ORGANIZATION_NAME, APPLICATION_NAME);
    settings.setValue("Main/Transition", transition);
    setTransition(transition);
}

void QFlipClock_Widget::setNewTheme(QString name)
{
    QSettings settings(ORGANIZATION_NAME, APPLICATION_NAME);
    settings.setValue("Main/Theme", name);
    updateTheme();
    repaint();
}

void QFlipClock_Widget::setNewClickAction(ActionEnum action)
{
    QSettings settings(ORGANIZATION_NAME, APPLICATION_NAME);
    settings.setValue("Main/ClickAction", action);
    _clickAction = action;
}

void QFlipClock_Widget::setNewShowBackground(bool value)
{
    QSettings  settings(ORGANIZATION_NAME, APPLICATION_NAME);
    settings.setValue("Main/ShowBackground", value);
    toggleShowBackground(value);
    repaint();
}

void QFlipClock_Widget::setNewZeroSign(bool value)
{
    QSettings  settings(ORGANIZATION_NAME, APPLICATION_NAME);
    settings.setValue("Main/PrependZeroSign", value);
    toggleZeroSign(value);
    repaint();
}

void QFlipClock_Widget::launchApp()
{
    if (_clickAction == Action_Flipclock)
    {
        QDBusConnection bus = QDBusConnection::sessionBus();
        QDBusInterface dbus_iface("com.nokia.HildonDesktop.AppMgr",
                                  "/com/nokia/HildonDesktop/AppMgr",
                                  "com.nokia.HildonDesktop.AppMgr",
                                  bus);
        dbus_iface.call("LaunchApplication","qflipclock");
    }
    else if (_clickAction == Action_Maemoclock)
    {
        QDBusConnection bus = QDBusConnection::sessionBus();
        QDBusInterface dbus_iface("com.nokia.HildonDesktop.AppMgr",
                                  "/com/nokia/HildonDesktop/AppMgr",
                                  "com.nokia.HildonDesktop.AppMgr",
                                  bus);
        dbus_iface.call("LaunchApplication","worldclock");
    }
}

void QFlipClock_Widget::mouseReleaseEvent(QMouseEvent *)
{
        launchApp();
}

