#include "settings.h"
#include "ui_settings.h"

#include <QSettings>
#include <QAbstractButton>
#include <QStringList>
#include <QDir>
#include <QDebug>

#include "config.h"

Settings::Settings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Settings)
{
    ui->setupUi(this);

    QSettings settings(ORGANIZATION_NAME, APPLICATION_NAME);
    _transition = TransitionsEnum(
            settings.value("Main/Transition", Transition_Flip).toInt());

    // Transitions
    QStringList transitions;
    transitions << tr("None") << tr("Slide")
                << tr("Flip") << tr("Rotate");
    ui->transitionCombo->blockSignals(true);
    ui->transitionCombo->insertItems(0, transitions);
    ui->transitionCombo->setCurrentIndex(_transition);
    ui->transitionCombo->blockSignals(false);
    
    // Themes
    _theme = settings.value("Main/Theme", "White Flip").toString();
    QDir themesDir(THEMES_DIR);
    QStringList filter("*.ini");
    QStringList fileList = themesDir.entryList(filter, QDir::Files);
    QString str;
    ui->themesCombo->blockSignals(true);
    foreach (str, fileList)
    {
        QSettings theme(THEMES_DIR + str, QSettings::IniFormat);
        QString name = theme.value("Theme/Name",
                                   tr("unnamed")).toString();
        ui->themesCombo->insertItem(0, name);
    }
    ui->themesCombo->setCurrentIndex(ui->themesCombo->findText(_theme));
    ui->themesCombo->blockSignals(false);

    // Backlight
    _keepBacklight = settings.value("Main/KeepBacklightOn", true).toBool();
    ui->backlightCheck->blockSignals(true);
    ui->backlightCheck->setChecked(_keepBacklight);
    ui->backlightCheck->blockSignals(false);

    // Add Zero Sign?
    _zeroSign = settings.value("Main/PrependZeroSign", true).toBool();
    ui->zeroCheckBox->setChecked(_zeroSign);
}

Settings::~Settings()
{
    delete ui;
}

void Settings::on_pushButton_clicked()
{
    accept();
}

void Settings::on_transitionCombo_activated(int index)
{
    _transition = TransitionsEnum(index);
}

void Settings::on_themesCombo_activated(QString text)
{
    _theme = text;
}

void Settings::on_backlightCheck_toggled(bool checked)
{
    _keepBacklight = checked;
}

void Settings::on_zeroCheckBox_clicked(bool checked)
{
   _zeroSign = checked;
}
