#ifndef QFLIPCLOCK_APP_H
#define QFLIPCLOCK_APP_H

#include "qflipclock.h"
#include "sheet.h"

#ifdef Q_WS_MAEMO_5
#include <QtDBus/QtDBus>
#include <QBasicTimer>
#include <QTimerEvent>
#endif

class QFlipClock_App : public QFlipClock
{
    Q_OBJECT
public:
    QFlipClock_App();

public slots:
    void showSettingsDialog();
#ifdef Q_WS_MAEMO_5
    void screenChange(const QDBusMessage &message);
#endif

protected:
#ifdef Q_WS_MAEMO_5
    void timerEvent(QTimerEvent *event);
#endif
    void mousePressEvent(QMouseEvent *);

private:
    void setNewTransition(TransitionsEnum transition);
    void setNewTheme(QString name);
    void setNewZeroSign(bool value);

#ifdef Q_WS_MAEMO_5
    void setNewKeepBacklight(bool value);

    QDBusInterface * _dBusInterface;

    QBasicTimer _backlightTimer;
    void startBacklightOn();
    void stopBacklightOn();
#endif

    void toggleSize();
};

#endif
