#ifndef SHEET_H
#define SHEET_H

#include <QWidget>
#include <QResizeEvent>
#include <QPaintEvent>
#include <QRect>
#include <QPainter>
#include <QPixmap>
#include <QTimeLine>

#include "theme.h"

enum TransitionsEnum {
    Transition_None,
    Transition_Slide,
    Transition_Flip,
    Transition_Rotate
};

Q_DECLARE_METATYPE (TransitionsEnum);

class Sheet : public QWidget
{
    Q_OBJECT
public:
    Sheet(QWidget *parent = 0,
          Theme *theme = 0);
    void setTransition(TransitionsEnum tr);
    TransitionsEnum transition() const;
    void setNumber(int n);
    void flipTo(int n, bool force);
    void reloadTheme();

protected:
    void drawFrame(QPainter *p, const QRect &rect);
    QPixmap drawDigits(int n, const QRect &rect, bool addZero);
    virtual void preparePixmap();
    void paintEvent(QPaintEvent *event);
    void resizeEvent(QResizeEvent*);
    void paintStatic();
    void paintSlide();
    void paintFlip();
    void paintRotate();
    int _number;
    Theme * _theme;
    QPixmap _pixmap;

private:
    TransitionsEnum _transition;
    QPixmap _lastPixmap;
    QTimeLine _animator;

};

#endif // SHEET_H
