#ifndef QFLIPCLOCK_H
#define QFLIPCLOCK_H

#include <QWidget>
#ifdef QFLIPCLOCK_STANDALONE
#include <QMainWindow>
#endif
#include <QResizeEvent>
#include <QTimerEvent>
#include <QPaintEvent>
#include <QBasicTimer>

#ifdef Q_WS_MAEMO_5
#include "gq/GConfItem"
#endif

#include "sheet.h"
#include "theme.h"
#include "config.h"
#include "hour.h"

#ifdef QFLIPCLOCK_WIDGET
class QFlipClock : public QWidget
#else
class QFlipClock : public QMainWindow
#endif
{
    Q_OBJECT

public:
#ifdef QFLIPCLOCK_WIDGET
    QFlipClock(QWidget *parent = 0);
#else
    QFlipClock(QMainWindow *parent = 0);
#endif
    ~QFlipClock();

    void updateTime(bool force = false);
    void setTransition(TransitionsEnum i);
    void toggleShowBackground(bool value);
    void toggleZeroSign(bool value);
    void updateTheme();

    void startTimer();
    void stopTimer();

    int getHeight(int width);

protected:
    void resizeEvent(QResizeEvent*);
    void timerEvent(QTimerEvent * event);
    void paintEvent(QPaintEvent *);

private slots:
    void setHoursMode();

private:
    QBasicTimer _ticker;
    Hour *_hour;
    Sheet *_minute;

    TransitionsEnum _transition;

    qreal _aspect;
    qreal _xpad;
    qreal _gap; // gap between hours and minutes sheets

    bool _hasSemicolon;

    Theme * _theme;
#ifdef Q_WS_MAEMO_5
    GConfItem * is24;
#endif

    bool _showBackground;

    void reloadTheme();
    void drawBackground(QPainter * p);
    void drawSemicolon(QPainter * p);
};

#endif // QFLIPCLOCK_H
