#ifndef XML_H
#define XML_H
#include <QString>
#include <QtXml>

class XML
{
public:
    XML();
    QList<QString> openEx(QString name);
    QList<QString> openGroup(QString group);
    //int saveNewEx( QDomDocument &d, QString name, QString group, QString muscle,
      //             QString info);

    void saveSettings(QString vibrate, QString sound, QString volume
                      ,QString set, QString min, QString sec, QString calories);
    void saveEx(QString name, QString group, QString muscle,
                   QString info, QString newName = "0");
    QList <QString> loadSettings();
    QList<QString> openAll();

    void saveProgram(QString name, QModelIndexList exercises);
    QList <QString> loadProgram(QString name);
    QList <QString> getPrograms();
    void removeProgram(QString name);

    void removeElement(QString name, QString filename);

    void saveCardio(QString name);
    void updateLastDistance(QString name, QString distance, QString min, QString sec, QString status);
    QList<QString> openCardio(QString name);
    QList<QString> openCardio();

    void saveFirstSet(QString group, QString name, QString kg, QString reps, QString status);
    void updateHistory(QString name, QString set, QString kg, QString reps, QString status);
    QList< QList <QString> > readHistory();
    QList <QString> getDates();
    QList < QList<QString> > getHistoryByDate(QString date);
    QList<QString> getHistoryByExercise(QString name, QString date = "0");
    void removeHistory(QString name, QString date);

    void saveFood(QString name, QString type, QString kcal, QString protein, QString carbohydrate, QString fat);
    QList<QString> openIngredients();
    void saveEatenFood(QString kcal, QString protein, QString carbohydrate, QString fat);
    QList <int> getTodaysCalories();
    void getMeanCalories();
    QList <int> getCaloriesByName(QString name);
    void removeIngredient(QString name);

    void import(QString filename);
    void exportExercises(QModelIndexList name);

private:
    QDomElement createCaloriesNode ( QDomDocument &d, QString kcal, QString protein, QString carbohydrate, QString fat, QString date);
    QDomElement createFoodNode( QDomDocument &d, QString name, QString type, QString kcal, QString protein, QString carbohydrate, QString fat);
    QDomElement createExerciseNode( QDomDocument &d, QString name, QString group, QString muscle,
                               QString info);
    QDomElement createCardioNode( QDomDocument &d, QString name);
    QDomElement createHistoryNode(QDomDocument &d, QString group, QString name, QString date, QString kg, QString reps, QString status);
    QDomElement createSettingsNode( QDomDocument &d, QString vibrate, QString sound, QString volume,
                               QString set, QString min, QString sec, QString calories);
    QDomElement createProgramNode(QDomDocument &d, QString name, QModelIndexList exercises);
};

#endif // XML_H
