#ifndef WEIGHTSETTINGS_H
#define WEIGHTSETTINGS_H

#include <QtGui>
#include "xml.h"
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>

class WeightSettings : public QDialog
{
    Q_OBJECT
public:
    explicit WeightSettings(QWidget *parent = 0);
    void load();

signals:

private slots:
    void orientationChanged();

private:
    XML *xml;

    void save();
    void closeEvent(QCloseEvent *event);

    QPushButton *btnSave;

    QStandardItemModel *modelSet;
    QStandardItemModel *modelReps1;
    QStandardItemModel *modelReps2;
    QStandardItemModel *modelReps3;
    QStandardItemModel *modelMin;
    QStandardItemModel *modelSec;
    QStandardItemModel *modelCurrentReps;


    QMaemo5ValueButton *btnSet;
    QMaemo5ValueButton *btnReps1;
    QMaemo5ValueButton *btnReps2;
    QMaemo5ValueButton *btnReps3;
    QMaemo5ValueButton *btnCurrentReps;
    QMaemo5ValueButton *btnMin;
    QMaemo5ValueButton *btnSec;


    QMaemo5ListPickSelector *selectorSet;
    QMaemo5ListPickSelector *selectorReps1;
    QMaemo5ListPickSelector *selectorReps2;
    QMaemo5ListPickSelector *selectorReps3;
    QMaemo5ListPickSelector *selectorCurrentReps;
    QMaemo5ListPickSelector *selectorMin;
    QMaemo5ListPickSelector *selectorSec;

};

#endif // WEIGHTSETTINGS_H
