#include "othersettings.h"

OtherSettings::OtherSettings(QWidget *parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5PortraitOrientation);
    setWindowTitle("Other settings");

    QVBoxLayout *vLayout = new QVBoxLayout;

    chbVibrate = new QCheckBox("Vibrate");
    vLayout->addWidget(chbVibrate);

    chbSound = new QCheckBox("Sound");
    chbSound->setEnabled(false);
    vLayout->addWidget(chbSound);


    QLabel *label = new QLabel("Volume");
    label->setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Minimum);
    sliderVolume = new QSlider(Qt::Horizontal);
    sliderVolume->setEnabled(false);
    sliderVolume->setRange(0,100);
    vLayout->addWidget(label);
    vLayout->addWidget(sliderVolume);

    setLayout(vLayout);
}

void OtherSettings::save()
{
    QList <QString> settings = xml->loadSettings();
    if(settings.isEmpty())
        return;

    int v = sliderVolume->value();
    QString value; value.setNum(v);
    QString vibrate, sound;

    if(chbVibrate->isChecked())
        vibrate = "1";
    else
        vibrate = "0";

    if(chbSound->isChecked())
        sound = "1";
    else
        sound = "0";

    for(int i = 0; i < 3; i++)
        settings.removeFirst();

    xml->saveSettings("" + vibrate,
                 "" + sound,
                 "" + value,
                 "" + settings.takeFirst(),
                 "" + settings.takeFirst(),
                 "" + settings.takeFirst(),
                 "" + settings.takeFirst(),
                 "" + settings.takeFirst(),
                 "" + settings.takeFirst(),
                 "" + settings.takeFirst(),
                 "" + settings.takeFirst());
}

void OtherSettings::load()
{
    QList<QString> settings;
    QList<QStandardItem> list;
    QStandardItem tmpItem;
    QString vibrate, sound;

    settings = xml->loadSettings();
    if(settings.isEmpty())
        return;

    vibrate = settings.takeFirst();
    sound = settings.takeFirst();

    if(vibrate == "1")
        chbVibrate->setChecked(true);
    else
        chbVibrate->setChecked(false);

    if(sound == "1")
        chbSound->setChecked(true);
    else
        chbSound->setChecked(false);


    sliderVolume->setValue(settings.takeFirst().toInt());
}

void OtherSettings::closeEvent(QCloseEvent *event)
{
    save();
}
