#include "newingredientwindow.h"
#include <QMaemo5InformationBox>

NewIngredientWindow::NewIngredientWindow(QWidget *parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5PortraitOrientation);
    setWindowTitle("New Ingredient");
    xml = new XML();


    QVBoxLayout *vLayout = new QVBoxLayout;

    modelProtein = new QStandardItemModel(this);
    for (int i = 1; i < 100; i++)
        modelProtein->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnProtein = new QMaemo5ValueButton("Protein / 100g");
    btnProtein->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorProtein = new QMaemo5ListPickSelector();
    selectorProtein->setModel(modelProtein);
    btnProtein->setPickSelector(selectorProtein);

    modelCarbohydrate = new QStandardItemModel(this);
    for (int i = 1; i < 100; i++)
        modelCarbohydrate->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnCarbohydrate = new QMaemo5ValueButton("Carbohydrate / 100g");
    btnCarbohydrate->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorCarbohydrate = new QMaemo5ListPickSelector();
    selectorCarbohydrate->setModel(modelCarbohydrate);
    btnCarbohydrate->setPickSelector(selectorCarbohydrate);

    modelFat = new QStandardItemModel(this);
    for (int i = 1; i < 100; i++)
        modelFat->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnFat = new QMaemo5ValueButton("Fat / 100g");
    btnFat->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorFat = new QMaemo5ListPickSelector();
    selectorFat->setModel(modelFat);
    btnFat->setPickSelector(selectorFat);

    modelType = new QStandardItemModel(this);
    modelType->appendRow(new QStandardItem(tr("Drink")));
    modelType->appendRow(new QStandardItem(tr("Food")));

    btnType = new QMaemo5ValueButton("Type");
    btnType->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorType = new QMaemo5ListPickSelector();
    selectorType->setModel(modelType);
    btnType->setPickSelector(selectorType);

    txtName = new QLineEdit();
    txtName->setPlaceholderText("Name");

    vLayout->addWidget(txtName);
    vLayout->addWidget(btnType);
    vLayout->addWidget(btnProtein);
    vLayout->addWidget(btnCarbohydrate);
    vLayout->addWidget(btnFat);


    btnSave = new QPushButton("Save");
    connect(btnSave,SIGNAL(clicked()),this, SLOT(save()));
    vLayout->addWidget(btnSave);
    setLayout(vLayout);


}

void NewIngredientWindow::load()
{
    btnType->setFocus();
    btnType->setValueText("");
    txtName->setText("");
}

void NewIngredientWindow::save()
{
    int kcal = 0;
    QString calories;
    if(txtName->text() == "")
    {
        QMaemo5InformationBox::information(this, "You must fill in name.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    else if(btnType->valueText() == "")
    {
        QMaemo5InformationBox::information(this, "You must choose a type.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    else if(btnProtein->valueText() == "")
    {
        QMaemo5InformationBox::information(this, "You must choose an amount of protein.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    else if(btnCarbohydrate->valueText() == "")
    {
        QMaemo5InformationBox::information(this, "You must choose an amount of carbohydrate.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    else if(btnFat->valueText() == "")
    {
        QMaemo5InformationBox::information(this, "You must choose an amount of fat.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    kcal = btnProtein->valueText().toInt() * 4;
    kcal += btnCarbohydrate->valueText().toInt() * 4;
    kcal += btnFat->valueText().toInt() * 9;

    calories.setNum(kcal);

    xml->saveFood(txtName->text(), btnType->valueText(), calories,
                  btnProtein->valueText(), btnCarbohydrate->valueText(), btnFat->valueText());
    this->hide();
}
