#include "newexercisewindow.h"
#include <QMaemo5InformationBox>
#include <QDebug>

NewExerciseWindow::NewExerciseWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    //setAttribute(Qt::WA_Maemo5LandscapeOrientation);
    setWindowTitle("New exercise");
    xml = new XML();

    QWidget *widget = new QWidget();
    setCentralWidget(widget);

    QVBoxLayout *vLayout = new QVBoxLayout();
    txtName = new QLineEdit();
    txtName->setPlaceholderText("Name");
    txtMuscle = new QLineEdit();
    txtMuscle->setPlaceholderText("Muscle");
    txtHowTo = new QTextEdit("How to...");


    model = new QStandardItemModel(this);
    model->appendRow(new QStandardItem(tr("Arms")));
    model->appendRow(new QStandardItem(tr("Back")));
    model->appendRow(new QStandardItem(tr("Cardio")));
    model->appendRow(new QStandardItem(tr("Chest")));
    model->appendRow(new QStandardItem(tr("Legs")));
    model->appendRow(new QStandardItem(tr("Shoulder")));
    model->appendRow(new QStandardItem(tr("Stomach")));

    btnGroup = new QMaemo5ValueButton("Group");
    btnGroup->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorGroup = new QMaemo5ListPickSelector;
    selectorGroup->setModel(model);
    btnGroup->setPickSelector(selectorGroup);

    btnGroup->setValueText("Arms");

    btnSave = new QPushButton("Save");
    vLayout->addWidget(txtName);
    vLayout->addWidget(txtMuscle);
    vLayout->addWidget(btnGroup);
    vLayout->addWidget(txtHowTo);
    vLayout->addWidget(btnSave);

    widget->setLayout(vLayout);

    connect(btnSave, SIGNAL(clicked()),this, SLOT(saveExercise()));
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
}

void NewExerciseWindow::saveExercise()
{
    if(txtName->text() == "")
    {
        QMaemo5InformationBox::information(this, "You must fill in name.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    else if(txtMuscle->text() == "")
    {
        QMaemo5InformationBox::information(this, "You must fill in muscle.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    else if(btnGroup->valueText() == "")
    {
        QMaemo5InformationBox::information(this, "You must choose group.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    QString name = txtName->text();
    QString group = btnGroup->valueText();
    QString muscle = txtMuscle->text();
    QString info = txtHowTo->toPlainText();
    if(group == "Cardio")
        xml->saveCardio(name);
    else
        xml->saveEx(name,group,muscle,info);
    //if saved OK

    QMaemo5InformationBox::information(this, "Exercise saved.",
                                                QMaemo5InformationBox::DefaultTimeout);
    this->hide();
}
void NewExerciseWindow::load()
{
    btnGroup->setFocus();
    txtName->setText("");
    txtMuscle->setText("");;
    btnGroup->setValueText("");
    txtHowTo->setText("How to...");
}


void NewExerciseWindow::load(QString name, QString group, QString muscle, QString info)
{
    txtName->setEnabled(false);
    txtName->setText(name);
    txtMuscle->setText(muscle);
    btnGroup->setValueText(group);
    txtHowTo->setText(info);
}

void NewExerciseWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();

    if (screenGeometry.width() > screenGeometry.height())
    {
        btnGroup->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    }
    else
    {
        btnGroup->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    }


}
