#include "exercisewindow.h"
#include <mce/dbus-names.h>
#include <mce/mode-names.h>
#include <QDBusMessage>
#include <QDebug>



ExerciseWindow::ExerciseWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    widget = new QWidget();

    mx = 0; my = 0; mz = 0;
    proximity = false;

    sw = new SettingsWindow(this);
    sw->hide();
    niw = new NewIngredientWindow(this);
    niw->hide();
    hw = new HistoryWindow(this);
    hw->hide();
    nw = new NewExerciseWindow(this);
    nw->hide();
    npw = new NewProgramWindow(this);
    npw->hide();
    wd = new WeightDialog(this);
    wd->hide();

    xml = new XML();

    vLayout = new QVBoxLayout;

    label = new QLabel();
    label->setAlignment(Qt::AlignCenter);

    btnShake = new QPushButton("Done");


    connect(btnShake,SIGNAL(clicked()),this,SLOT(shaked()));

    vLayout->addWidget(label);
    vLayout->addWidget(btnShake);


    widget->setLayout(vLayout);
    setCentralWidget(widget);
    createActions();
    createMenu();

    timer = new QTimer(this);
    QObject::connect(timer, SIGNAL(timeout()), this, SLOT(updateTime()));

    myThread = new aThread(this);
    connect(myThread, SIGNAL(deviceOrientation(QString, QString, QString)),
            this, SLOT(checkAcc(QString)));
    connect(myThread, SIGNAL(proximityState(QString)),
            this, SLOT(checkProximity(QString)));


    interface = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH,
                                   MCE_REQUEST_IF, QDBusConnection::systemBus(),
                                   this);

    pause = QDBusMessage::createMethodCall("com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer",
                                           "/com/nokia/mafw/renderer/gstrenderer",
                                           "com.nokia.mafw.renderer",
                                           "pause");

    resume = QDBusMessage::createMethodCall("com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer",
                                            "/com/nokia/mafw/renderer/gstrenderer",
                                            "com.nokia.mafw.renderer",
                                            "resume");

    lock = QDBusMessage::createMethodCall("com.nokia.mce",
                                          "/com/nokia/mce/request",
                                          "com.nokia.mce.request",
                                          "req_tklock_mode_change");
    QList<QVariant> args;
    args.append("locked");
    lock.setArguments(args);
    QDBusConnection::sessionBus().send(lock);

    QDBusMessage reply = interface->call(MCE_ENABLE_VIBRATOR);
    if (reply.type() == QDBusMessage::ErrorMessage)
        qDebug() << reply.errorMessage();

    //reply = interface->call(MCE_TKLOCK_MODE_CHANGE_REQ, "MCE_TK_LOCKED");


    sound = new PlaySound();

}

void ExerciseWindow::loadExercise(QList<QString> name)
{
    QDBusConnection::sessionBus().send(lock);
    QList <QString> tmp;
    QList<QString> settings = xml->loadSettings();
    QString lstReps[3];
    settings.removeLast();
    SEC = settings.takeLast().toInt();
    MIN = settings.takeLast().toInt();

    currentReps = settings.takeLast();
    lstReps[2] = settings.takeLast();
    lstReps[1] = settings.takeLast();
    lstReps[0] = settings.takeLast();

    if(currentReps == "Easy")
        REPS = lstReps[0].toInt();
    else if(currentReps == "Mid")
        REPS = lstReps[1].toInt();
    else
        REPS = lstReps[2].toInt();


    SET = settings.takeLast().toInt();

    vibrateActive = false; soundActive = false;
    if(settings.takeFirst() == "1")
        vibrateActive = true;
    if(settings.takeFirst() == "1")
        soundActive = true;

    currentExercise = name.first();
    tmp = xml->openEx(currentExercise);
    tmp.removeFirst();
    currentGroup = tmp.takeFirst();

    set = SET; reps = REPS; min = MIN; sec = SEC;
    strSet.setNum(SET); strReps.setNum(REPS); strMin.setNum(MIN);  strSec.setNum(SEC);
    label->setText(currentExercise + "\n Shake when done " + strReps + " reps");
    btnShake->setEnabled(true);
    myThread->start(QThread::NormalPriority);
}

void ExerciseWindow::changeEvent(QEvent *event)
{
    //qDebug() << label->text();
    this->update();
}

void ExerciseWindow::showNewIngredient()
{
    niw->load();
    niw->show();
}
void ExerciseWindow::showSettings()
{
    sw->load();
    sw->show();
}

void ExerciseWindow::showNewExercise()
{
    nw->load();
    nw->show();
}

void ExerciseWindow::showHistory()
{
    hw->load();
    hw->show();
}

void ExerciseWindow::showNewProgram()
{
    npw->show();
}

void ExerciseWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("&Menu"));
    menu->addAction(historyAction);
    menu->addAction(settingsAction);
    menu->addAction(newExerciseAction);
    menu->addAction(newProgramAction);
    menu->addAction(newIngredientAction);
    menu->addAction(skipAction);
}

void ExerciseWindow::createActions()
{
    historyAction = new QAction("History",this);
    settingsAction = new QAction("Settings",this);
    newExerciseAction = new QAction("New Exercise",this);
    newProgramAction = new QAction("New program",this);
    newIngredientAction = new QAction("New Ingredient",this);
    skipAction = new QAction("Skip wait", this);

    connect(historyAction, SIGNAL(triggered()), this, SLOT(showHistory()));
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(showSettings()));
    connect(newExerciseAction, SIGNAL(triggered()), this, SLOT(showNewExercise()));
    connect(newProgramAction, SIGNAL(triggered()), this, SLOT(showNewProgram()));
    connect(newIngredientAction, SIGNAL(triggered()), this, SLOT(showNewIngredient()));
    connect(skipAction,SIGNAL(triggered()), this, SLOT(skipWait()));
}

void ExerciseWindow::updateTime()
{

    //count down wait
    strMin.setNum(min); strSec.setNum(sec); strSet.setNum(set);
    QString str = strMin + ":" + strSec + " rest left (" + strSet + "set)";
    btnShake->setEnabled(false);
    label->setText(str);

    if(sec <= 0)
    {
        sec = 60;
        min--;
        if(min == -1)
        {
            //wait is over

            strReps.setNum(reps);
            label->setText("Exercise: " + currentExercise +  "\n Shake when done " + strReps + "reps");
            btnShake->setEnabled(true);



            timer->stop();

            if(soundActive == true)
            {
                //if(music playing)
                QDBusConnection::sessionBus().send(pause);
                tmrPause = new QTimer(this);
                tmrPause->setSingleShot(true);
                QObject::connect(tmrPause, SIGNAL(timeout()), this, SLOT(resumeMusic()));
                tmrPause->start(3000);  //ndra hr fr olika vibrationslngd
                sound->playWait();

            }

            myThread->start(QThread::NormalPriority);

            if(vibrateActive == true)
            {
                vibrate();
                tmr = new QTimer(this);
                tmr->setSingleShot(true);
                QObject::connect(tmr, SIGNAL(timeout()), this, SLOT(stopVibrate()));
                tmr->start(3000);  //ndra hr fr olika vibrationslngd
            }
        }
    }
    sec--;

}

void ExerciseWindow::resumeMusic()
{
    QDBusConnection::sessionBus().send(resume);
}

void ExerciseWindow::skipWait()
{
    min = 0;
    sec = 0;
}

void ExerciseWindow::checkProximity(QString data)
{
    if(data.left(6) == "closed")
    {
        proximity = true;
    }
    else
    {
        proximity = false;
    }

}

void ExerciseWindow::checkAcc(QString x)
{

    if(x.toInt() > 2200 || x.toInt() < -2200)
    {
        if(proximity == false)
        {
            vibrate();
            tmr = new QTimer(this);
            tmr->setSingleShot(true);
            QObject::connect(tmr, SIGNAL(timeout()), this, SLOT(stopVibrate()));
            tmr->start(1000);  //ndra hr fr olika vibrationslngd

            shaked();
        }

    }
}

void ExerciseWindow::shaked()
{
    QDBusMessage reply;
    if(set == -1)
        return;

    min = MIN; sec = SEC;

    set--;

    if(set == 0)
    {
        timer->stop();
        if(soundActive == true)
        {
            QDBusConnection::sessionBus().send(pause);
            tmrPause = new QTimer(this);
            tmrPause->setSingleShot(true);
            QObject::connect(tmrPause, SIGNAL(timeout()), this, SLOT(resumeMusic()));
            tmrPause->start(3000);  //ndra hr fr olika vibrationslngd
            sound->playDone();
            //wait x ms
            //QDBusConnection::sessionBus().send(resume);

        }

        wd->load(currentExercise, currentGroup, currentReps);
        wd->show();
        if(!exercises.isEmpty())
        {
            exercises.removeFirst();
            loadExercise(exercises);
            return;
        }
        else
        {
            label->setText("Exercise(s) completed!");
            btnShake->setEnabled(false);
            return;
        }

    }

    //Start wait and count down
    strMin.setNum(min); strSec.setNum(sec); strSet.setNum(set);
    QString str = strMin + ":" + strSec + " rest left (" + strSet + "set)";
    label->setText(str);
    btnShake->setEnabled(false);


    reply = interface->call(MCE_TKLOCK_MODE_CHANGE_REQ, "locked");

    timer->start(1000); //count down every second
    myThread->quit(); //stop check accelerometer
}

void ExerciseWindow::vibrate()
{
    QDBusMessage reply;

    reply = interface->call(MCE_ACTIVATE_VIBRATOR_PATTERN, "PatternIncomingCall");
    if (reply.type() == QDBusMessage::ErrorMessage)
        qDebug() << reply.errorMessage();
}

void ExerciseWindow::stopVibrate()
{
    QDBusMessage reply;

    reply = interface->call(MCE_DEACTIVATE_VIBRATOR_PATTERN, "PatternIncomingCall");
    if (reply.type() == QDBusMessage::ErrorMessage)
        qDebug() << reply.errorMessage();
}

void ExerciseWindow::closeEvent(QCloseEvent *event)
{
    myThread->quit();
    timer->stop();
}
