#include "newingredientwindow.h"
#include <QMaemo5InformationBox>

NewIngredientWindow::NewIngredientWindow(QWidget *parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5PortraitOrientation);
    setWindowTitle("New Ingredient");
    xml = new XML();


    QVBoxLayout *vLayout = new QVBoxLayout;

    modelCalories = new QStandardItemModel(this);
    for (int i = 1; i < 500; i++)
        modelCalories->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnCalories = new QMaemo5ValueButton("Calories / 100g");
    btnCalories->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorCalories = new QMaemo5ListPickSelector();
    selectorCalories->setModel(modelCalories);
    btnCalories->setPickSelector(selectorCalories);

    modelType = new QStandardItemModel(this);
    modelType->appendRow(new QStandardItem(tr("Drink")));
    modelType->appendRow(new QStandardItem(tr("Food")));

    btnType = new QMaemo5ValueButton("Type");
    btnType->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorType = new QMaemo5ListPickSelector();
    selectorType->setModel(modelType);
    btnType->setPickSelector(selectorType);

    txtName = new QLineEdit();
    txtName->setPlaceholderText("Name");

    vLayout->addWidget(txtName);
    vLayout->addWidget(btnType);
    vLayout->addWidget(btnCalories);


    btnSave = new QPushButton("Save");
    connect(btnSave,SIGNAL(clicked()),this, SLOT(save()));
    vLayout->addWidget(btnSave);
    setLayout(vLayout);


}

void NewIngredientWindow::load()
{
    btnCalories->setFocus();
    btnCalories->setValueText("");
    btnType->setValueText("");
    txtName->setText("");
}

void NewIngredientWindow::save()
{
    if(txtName->text() == "")
    {
        QMaemo5InformationBox::information(this, "You must fill in name.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    else if(btnType->valueText() == "")
    {
        QMaemo5InformationBox::information(this, "You must choose a type.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    else if(btnCalories->valueText() == "")
    {
        QMaemo5InformationBox::information(this, "You must choose an amount of calories.", QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    xml->saveFood(txtName->text(),"Food", btnCalories->valueText());
    this->hide();
}
