#include "dayhistory.h"

DayHistory::DayHistory(QWidget *parent) :
        QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);

    xml = new XML();

    lstExercises = new QListView();
    model = new QStandardItemModel(this);
    lstExercises->setModel(model);
    lstExercises->setSelectionMode(QListView::NoSelection);
    setCentralWidget (lstExercises);
}


void DayHistory::load(QString date)
{
    QList <QString> tmp;
    QString name, group, reps, var;
    setWindowTitle(date);
    model->clear();
    exercises = xml->getHistoryByDate(date);

    while(!exercises.isEmpty())
    {
        tmp = exercises.takeFirst();
        name = tmp.takeFirst();
        group = tmp.takeFirst();
        var = tmp.takeFirst();
        reps = tmp.takeFirst();

        if(group != "Cardio")
            model->appendRow(new QStandardItem(group + "/" + name + ": " + var + "Kg - " + reps + " reps"));
        else
            model->appendRow(new QStandardItem(group + "/" + name + ": " + var + "Km - " + reps));
    }

}
