#include "historywindow.h"



HistoryWindow::HistoryWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setWindowTitle("History");

    dh = new DayHistory(this);

    lstDates = new QListView();
    model = new QStandardItemModel(this);
    dates = xml->getDates();
    while(!dates.isEmpty())
    {
        model->appendRow(new QStandardItem(dates.takeFirst()));
    }
    lstDates->setModel(model);

    connect(lstDates,SIGNAL(clicked(QModelIndex)),this,SLOT(showExercises(QModelIndex)));

    setCentralWidget(lstDates);
}

void HistoryWindow::showExercises(QModelIndex index)
{
    dh->load(index.data().toString());
    dh->show();
}

void HistoryWindow::load()
{
    model = new QStandardItemModel(this);

    dates = xml->getDates();
    while(!dates.isEmpty())
    {
        model->appendRow(new QStandardItem(dates.takeFirst()));
    }
}
