/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef ONEFICHIER_H
#define ONEFICHIER_H

#include <QObject>
#include <QUrl>
#ifdef DOWNLOAD_TEST
#include <QFile>
#include <QSslError>
#endif
#include "serviceplugin.h"

class QTimer;
#ifdef DOWNLOAD_TEST
class QNetworkReply;
#endif

class OneFichier : public ServicePlugin
{
    Q_OBJECT
    Q_INTERFACES(ServiceInterface)

public:
    explicit OneFichier(QObject *parent = 0);
    ServicePlugin* createServicePlugin() { return new OneFichier; }
    inline QString iconName() const { return QString("onefichier.jpg"); }
    inline QString serviceName() const { return QString("1fichier"); }
    QRegExp urlPattern() const;
    bool urlSupported(const QUrl &url) const;
    void checkUrl(const QUrl &url);
    void getDownloadRequest(const QUrl &url);
    inline bool loginSupported() const { return true; }
    void login(const QString &username, const QString &password);
    inline bool recaptchaRequired() const { return false; }
    inline int maximumConnections() const { return m_connections; }
    bool cancelCurrentOperation();
#ifdef DOWNLOAD_TEST
    void downloadTest(const QUrl &url, const QString &fileName);
#endif

private:
    void startWait(int msecs);
    void getDownloadLink(const QUrl &url);

private slots:
    void checkLogin();
    void checkUrlIsValid();
    void onWebPageDownloaded();
    void updateWaitTime();
    void onWaitFinished();
    void checkDownloadLink();
#ifdef DOWNLOAD_TEST
    void onDownloadRequestReady(const QNetworkRequest &request);
    void onDownloadProgressChanged(qint64 received, qint64 total);
    void onDownloadReadyRead();
    void onDownloadFinished();
    void onDownloadError(ServicePlugin::ErrorType e);
    void onDownloadSSLErrors(const QList<QSslError> &errors);
#endif

signals:
    void currentOperationCancelled();

private:
    int m_wait;
    QTimer *m_waitTimer;
    int m_waitTime;
    int m_connections;
#ifdef DOWNLOAD_TEST
    QNetworkReply *m_downloadReply;
    QFile m_downloadFile;
#endif
};

#endif // ONEFICHIER_H
