#include "pluginsettingsselector.h"
#include "../shared/selectionmodels.h"
#include <QMaemo5ListPickSelector>
#include <QSettings>

PluginSettingsSelector::PluginSettingsSelector(const QString &text, QWidget *parent) :
    ValueSelector(text, parent)
{
    this->setModel(new SelectionModel(this));
}

PluginSettingsSelector::~PluginSettingsSelector() {}

void PluginSettingsSelector::setKey(const QString &key) {
    m_key = key;
}

void PluginSettingsSelector::setDefaultValue(const QVariant &value) {
    m_default = value;
}

void PluginSettingsSelector::load() {
    if (!this->model()) {
        return;
    }

    QVariant value = QSettings("QDL", "QDL").value(this->key(), this->defaultValue());

    bool found = false;
    int i = 0;

    while ((!found) && (i < this->model()->rowCount())) {
        found = this->model()->value(i) == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

void PluginSettingsSelector::onSelected() {
    if (!this->key().isEmpty()) {
        QSettings("QDL", "QDL").setValue(this->key(), this->currentValue());
    }
}
