#ifndef ADDURLSDIALOG_H
#define ADDURLSDIALOG_H

#include <QDialog>

class QTextEdit;
class QDialogButtonBox;

class AddUrlsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit AddUrlsDialog(QWidget *parent = 0);
    ~AddUrlsDialog();

    QString text() const;

public slots:
    void setText(const QString &text);
    void parseUrlsFromTextFile(const QString &fileName);

private slots:
    void onTextChanged();
    void setCategory(const QVariant &value);
    void parseUrls();
    
private:
    QTextEdit *m_urlsEdit;
    QDialogButtonBox *m_buttonBox;
};

#endif // ADDURLSDIALOG_H
