#include "dbusservice.h"
#include "../shared/transfermodel.h"
#include "../shared/urlchecker.h"
#include "../shared/urlretriever.h"

DBusService* DBusService::m_instance = 0;

DBusService::DBusService() :
    QObject()
{
    if (!m_instance) {
        m_instance = this;
    }
}

DBusService::~DBusService() {}

DBusService* DBusService::instance() {
    return !m_instance ? new DBusService : m_instance;
}

void DBusService::addUrls(const QStringList &urls) {
    UrlChecker::instance()->addUrlsToQueue(urls);
}

void DBusService::importUrls(const QStringList &urls) {
    foreach (QString url, urls) {
        UrlChecker::instance()->importUrlsFromTextFile(url);
    }
}

void DBusService::retrieveUrls(const QStringList &urls) {
    UrlRetriever::instance()->addUrlsToQueue(urls);
}

QVariantList DBusService::getDownloads() const {
    return TransferModel::instance()->allItemData();
}

QVariantMap DBusService::getDownload(const QString &id) const {
    return TransferModel::instance()->itemData(id);
}

QVariant DBusService::getDownloadProperty(const QString &id, const QString &property) {
    return TransferModel::instance()->data(id, property.toUtf8());
}

bool DBusService::setDownloadProperty(const QString &id, const QString &property, const QDBusVariant &value) {
    return TransferModel::instance()->setData(id, value.variant(), property.toUtf8());
}

bool DBusService::start() {
    return TransferModel::instance()->start();
}

bool DBusService::pause() {
    return TransferModel::instance()->pause();
}

bool DBusService::start(const QString &id) {
    return TransferModel::instance()->start(id);
}

bool DBusService::pause(const QString &id) {
    return TransferModel::instance()->pause(id);
}

bool DBusService::remove(const QString &id) {
    return TransferModel::instance()->cancel(id);
}
