#ifndef CATEGORYSETTINGSTAB_H
#define CATEGORYSETTINGSTAB_H

#include <QWidget>

class CategoriesModel;
class QTreeView;
class QPushButton;
class QLineEdit;
class QModelIndex;
class QMenu;

class CategorySettingsTab : public QWidget
{
    Q_OBJECT

public:
    explicit CategorySettingsTab(QWidget *parent = 0);

private slots:
    void showContextMenu(const QPoint &pos);
    void addCategory();
    void removeCategory();
    void editCategory();
    void showFolderDialog();
    void onCategoryEditChanged();
    
private:
    CategoriesModel *m_model;
    QTreeView *m_view;
    QMenu *m_contextMenu;
    QAction *m_editAction;
    QAction *m_removeAction;
    QPushButton *m_addButton;
    QLineEdit *m_nameEdit;
    QLineEdit *m_pathEdit;
    QPushButton *m_browseButton;
    QPushButton *m_doneButton;
};

#endif // CATEGORYSETTINGSTAB_H
