#ifndef ADDURLSDIALOG_H
#define ADDURLSDIALOG_H

#include <QDialog>

class QTextEdit;
class QDialogButtonBox;
class QGridLayout;
class QComboBox;

class AddUrlsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit AddUrlsDialog(QWidget *parent = 0);
    ~AddUrlsDialog();

    QString text() const;

public slots:
    void setText(const QString &text);
    void parseUrlsFromTextFile(const QString &fileName);

protected:
    void dragEnterEvent(QDragEnterEvent *event);
    void dropEvent(QDropEvent *event);

private slots:
    void onTextChanged();
    void parseUrls();
    
private:
    QTextEdit *m_urlsEdit;
    QComboBox *m_comboBox;
    QDialogButtonBox *m_buttonBox;
    QGridLayout *m_grid;
};

#endif // ADDURLSDIALOG_H
