#ifndef CLIPBOARDMONITOR_H
#define CLIPBOARDMONITOR_H

#include <QObject>
#include <qplatformdefs.h>

#ifdef MEEGO_EDITION_HARMATTAN
class QTimer;
#endif

class ClipboardMonitor : public QObject
{
    Q_OBJECT

public:
    static ClipboardMonitor* instance();

private:
    ClipboardMonitor();
    ~ClipboardMonitor();
    
private slots:
    void onMonitorClipboardChanged(bool monitor);
    void onClipboardTextChanged();

signals:
    void clipboardUrlsReady(const QString &urls);

private:
    static ClipboardMonitor* m_instance;
#ifdef MEEGO_EDITION_HARMATTAN
    QTimer *m_timer;
#endif
};

#endif // CLIPBOARDMONITOR_H
