#include "archivepasswordsmodel.h"
#include "database.h"

ArchivePasswordsModel::ArchivePasswordsModel(QObject *parent) :
    QStringListModel(parent)
{
    this->setStringList(Database::instance()->getArchivePasswords());
}

ArchivePasswordsModel::~ArchivePasswordsModel() {}

void ArchivePasswordsModel::addPassword(const QString &password) {
    if (Database::instance()->addArchivePassword(password)) {
        this->setStringList(Database::instance()->getArchivePasswords());
    }
}

void ArchivePasswordsModel::removePassword(const QString &password) {
    if (Database::instance()->removeArchivePassword(password)) {
        this->setStringList(Database::instance()->getArchivePasswords());
    }
}

void ArchivePasswordsModel::removePassword(int row) {
    this->removePassword(this->data(this->index(row), Qt::DisplayRole).toString());
}
