#include "settingsdialog.h"
#include "downloadsettingstab.h"
#include "proxysettingstab.h"
#include "categorysettingstab.h"
#include "accountsettingstab.h"
#include "captchasettingstab.h"
#include "pluginsettingstab.h"
#include "../shared/pluginsettingsmodel.h"
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QTabWidget>
#include <QPushButton>

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent)
{
    this->setWindowTitle(tr("Preferences"));
    this->setAttribute(Qt::WA_DeleteOnClose, true);

    DownloadSettingsTab *downloadsTab = new DownloadSettingsTab(this);
    ProxySettingsTab *proxyTab = new ProxySettingsTab(this);
    CategorySettingsTab *categoriesTab = new CategorySettingsTab(this);
    AccountSettingsTab *accountsTab = new AccountSettingsTab(this);
    CaptchaSettingsTab *captchaTab = new CaptchaSettingsTab(this);
    PluginSettingsTab *pluginsTab = new PluginSettingsTab(this);

    QTabWidget *tabWidget = new QTabWidget(this);
    tabWidget->addTab(downloadsTab, tr("General"));
    tabWidget->addTab(proxyTab, tr("Proxy"));
    tabWidget->addTab(categoriesTab, tr("Categories"));
    tabWidget->addTab(accountsTab, tr("Accounts"));
    tabWidget->addTab(captchaTab, tr("Decaptcha"));
    tabWidget->addTab(pluginsTab, tr("Plugins"));

    QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Save | QDialogButtonBox::Cancel, Qt::Horizontal, this);

    QVBoxLayout *vbox = new QVBoxLayout(this);
    vbox->addWidget(tabWidget);
    vbox->addWidget(buttonBox);

    this->connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
    this->connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    this->connect(buttonBox, SIGNAL(accepted()), downloadsTab, SLOT(saveSettings()));
    this->connect(buttonBox, SIGNAL(accepted()), proxyTab, SLOT(saveSettings()));
}

SettingsDialog::~SettingsDialog() {}
