#ifndef CAPTCHADIALOG_H
#define CAPTCHADIALOG_H

#include <QDialog>

class QLabel;
class QLineEdit;
class QPushButton;
class QTimer;

class CaptchaDialog : public QDialog
{
    Q_OBJECT

public:
    explicit CaptchaDialog(QWidget *parent = 0);
    ~CaptchaDialog();
    
public slots:
    void setCaptchaImage(const QPixmap &image);
    void setTimeout(int secs);

private slots:
    void onCaptchaTextChanged(const QString &text);
    void submitCaptchaResponse();
    void onTimeout();

signals:
    void captchaResponseReady(const QString &text);

private:
    QLabel *m_imageLabel;
    QLineEdit *m_responseEdit;
    QLabel *m_timeoutLabel;
    QPushButton *m_doneButton;
    QPushButton *m_cancelButton;
    QTimer *m_timer;
    int m_timeout;
};

#endif // CAPTCHADIALOG_H
